/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.Evaluator;
import com.rabbitmq.jms.parse.ParseTreeTraverser;
import com.rabbitmq.jms.parse.sql.SqlEvaluatorVisitor;
import com.rabbitmq.jms.parse.sql.SqlExpressionType;
import com.rabbitmq.jms.parse.sql.SqlParseTree;
import com.rabbitmq.jms.parse.sql.SqlParser;
import com.rabbitmq.jms.parse.sql.SqlTypeChecker;
import java.util.Map;

public class SqlEvaluator
implements Evaluator {
    private final SqlParseTree typedParseTree;
    private final String errorMessage;
    private final boolean evaluatorOk;

    public SqlEvaluator(SqlParser parser, Map<String, SqlExpressionType> identTypes) {
        if (parser.parseOk()) {
            SqlParseTree parseTree = parser.parse();
            this.evaluatorOk = SqlEvaluator.canBeBool(SqlTypeChecker.deriveExpressionType(parseTree, identTypes));
            if (this.evaluatorOk) {
                this.typedParseTree = parseTree;
                this.errorMessage = null;
            } else {
                this.errorMessage = "Type error in expression";
                this.typedParseTree = null;
            }
        } else {
            this.evaluatorOk = false;
            this.typedParseTree = null;
            this.errorMessage = parser.getErrorMessage();
        }
    }

    private static boolean canBeBool(SqlExpressionType set) {
        return set == SqlExpressionType.BOOL || set == SqlExpressionType.ANY;
    }

    @Override
    public boolean evaluate(Map<String, Object> env) {
        Object val;
        SqlEvaluatorVisitor eVisitor;
        if (this.evaluatorOk && ParseTreeTraverser.traverse(this.typedParseTree, eVisitor = new SqlEvaluatorVisitor(env)) && (val = this.typedParseTree.getNode().getExpValue().getValue()) != null && val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    public SqlParseTree typedParseTree() {
        return this.typedParseTree;
    }

    @Override
    public boolean evaluatorOk() {
        return this.evaluatorOk;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

