/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.Visitor;
import com.rabbitmq.jms.parse.sql.SqlToken;
import com.rabbitmq.jms.parse.sql.SqlTokenType;
import com.rabbitmq.jms.parse.sql.SqlTreeNode;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SqlEvaluatorVisitor
implements Visitor<SqlTreeNode> {
    private final Map<String, Object> env;

    SqlEvaluatorVisitor(Map<String, Object> env) {
        this.env = env;
    }

    public boolean visitBefore(SqlTreeNode parent, SqlTreeNode[] children) {
        return true;
    }

    public boolean visitAfter(SqlTreeNode parent, SqlTreeNode[] children) {
        Object[] childVals = new Object[children.length];
        for (int i = 0; i < children.length; ++i) {
            childVals[i] = children[i].getExpValue().getValue();
        }
        parent.getExpValue().setValue(SqlEvaluatorVisitor.valueOfParent(this.env, parent, childVals));
        return true;
    }

    private static final Object valueOfParent(Map<String, Object> env, SqlTreeNode parent, Object[] vals) {
        switch (parent.treeType()) {
            case CONJUNCTION: {
                return SqlEvaluatorVisitor.logicalAnd(vals[0], vals[1]);
            }
            case DISJUNCTION: {
                return SqlEvaluatorVisitor.logicalOr(vals[0], vals[1]);
            }
            case LEAF: {
                return SqlEvaluatorVisitor.leafValue(parent.value(), env);
            }
            case LIST: {
                return parent.value().getList();
            }
            case PATTERN1: {
                return SqlEvaluatorVisitor.pattern(vals[0], null);
            }
            case PATTERN2: {
                return SqlEvaluatorVisitor.pattern(vals[0], vals[1]);
            }
            case POSTFIXUNARYOP: 
            case PREFIXUNARYOP: 
            case TERNARYOP: 
            case BINARYOP: {
                return SqlEvaluatorVisitor.operationValue(parent.value().type(), vals);
            }
        }
        return null;
    }

    private static final Pattern pattern(Object o1, Object o2) {
        if (!SqlEvaluatorVisitor.isString(o1)) {
            return null;
        }
        String pattString = Pattern.quote((String)o1);
        boolean noEscape = true;
        char escChar = ' ';
        if (SqlEvaluatorVisitor.isString(o2) && ((String)o2).length() > 0) {
            noEscape = false;
            escChar = ((String)o2).charAt(0);
        }
        boolean nextAsis = false;
        StringBuilder sp = new StringBuilder();
        for (char ch : pattString.toCharArray()) {
            if (nextAsis) {
                sp.append(ch);
                nextAsis = false;
                continue;
            }
            if (!noEscape && ch == escChar) {
                nextAsis = true;
                continue;
            }
            if (ch == '_') {
                sp.append('.');
                continue;
            }
            if (ch == '%') {
                sp.append(".*");
                continue;
            }
            sp.append(ch);
        }
        return Pattern.compile(sp.toString());
    }

    private static final Object operationValue(SqlTokenType op, Object[] vals) {
        switch (op) {
            case NOT_BETWEEN: {
                return SqlEvaluatorVisitor.notBetween(vals[0], vals[1], vals[2]);
            }
            case BETWEEN: {
                return SqlEvaluatorVisitor.logicalNot(SqlEvaluatorVisitor.notBetween(vals[0], vals[1], vals[2]));
            }
            case CMP_EQ: {
                return SqlEvaluatorVisitor.equals(vals[0], vals[1]);
            }
            case CMP_NEQ: {
                return SqlEvaluatorVisitor.logicalNot(SqlEvaluatorVisitor.equals(vals[0], vals[1]));
            }
            case CMP_GT: {
                return SqlEvaluatorVisitor.greaterThan(vals[0], vals[1]);
            }
            case CMP_LTEQ: {
                return SqlEvaluatorVisitor.logicalNot(SqlEvaluatorVisitor.greaterThan(vals[0], vals[1]));
            }
            case CMP_LT: {
                return SqlEvaluatorVisitor.greaterThan(vals[1], vals[0]);
            }
            case CMP_GTEQ: {
                return SqlEvaluatorVisitor.logicalNot(SqlEvaluatorVisitor.greaterThan(vals[1], vals[0]));
            }
            case IN: {
                return SqlEvaluatorVisitor.in(vals[0], vals[1]);
            }
            case NOT_IN: {
                return SqlEvaluatorVisitor.logicalNot(SqlEvaluatorVisitor.in(vals[0], vals[1]));
            }
            case LIKE: {
                return SqlEvaluatorVisitor.like(vals[0], vals[1]);
            }
            case NOT_LIKE: {
                return SqlEvaluatorVisitor.logicalNot(SqlEvaluatorVisitor.like(vals[0], vals[1]));
            }
            case NULL: {
                return SqlEvaluatorVisitor.isNull(vals[0]);
            }
            case NOT_NULL: {
                return SqlEvaluatorVisitor.logicalNot(SqlEvaluatorVisitor.isNull(vals[0]));
            }
            case OP_DIV: {
                return SqlEvaluatorVisitor.divide(vals[0], vals[1]);
            }
            case OP_MINUS: {
                return vals.length > 1 ? SqlEvaluatorVisitor.subtract(vals[0], vals[1]) : SqlEvaluatorVisitor.subtract(0L, vals[0]);
            }
            case OP_MULT: {
                return SqlEvaluatorVisitor.multiply(vals[0], vals[1]);
            }
            case OP_PLUS: {
                return vals.length > 1 ? SqlEvaluatorVisitor.add(vals[0], vals[1]) : SqlEvaluatorVisitor.add(vals[0], 0L);
            }
            case NOT: {
                return SqlEvaluatorVisitor.logicalNot(vals[0]);
            }
        }
        return null;
    }

    private static final Boolean like(Object o1, Object o2) {
        if (!SqlEvaluatorVisitor.isString(o1)) {
            return null;
        }
        if (!SqlEvaluatorVisitor.isPattern(o2)) {
            return null;
        }
        Matcher matcher = ((Pattern)o2).matcher((String)o1);
        return matcher.matches();
    }

    private static final Object add(Object o1, Object o2) {
        if (SqlEvaluatorVisitor.isLong(o1)) {
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toLong(o1) + SqlEvaluatorVisitor.toLong(o2);
            }
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return new Double(o1.toString()) + SqlEvaluatorVisitor.toDouble(o2);
            }
            return null;
        }
        if (SqlEvaluatorVisitor.isDouble(o1)) {
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) + SqlEvaluatorVisitor.toDouble(o2);
            }
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) + new Double(o2.toString());
            }
            return null;
        }
        return null;
    }

    private static final long toLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        return ((Integer)o).longValue();
    }

    private static final boolean toBool(Object o) {
        return (Boolean)o;
    }

    private static final double toDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        return ((Float)o).doubleValue();
    }

    private static final Object subtract(Object o1, Object o2) {
        if (SqlEvaluatorVisitor.isLong(o1)) {
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toLong(o1) - SqlEvaluatorVisitor.toLong(o2);
            }
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return new Double(o1.toString()) - SqlEvaluatorVisitor.toDouble(o2);
            }
            return null;
        }
        if (SqlEvaluatorVisitor.isDouble(o1)) {
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) - SqlEvaluatorVisitor.toDouble(o2);
            }
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) - new Double(o2.toString());
            }
            return null;
        }
        return null;
    }

    private static final Object multiply(Object o1, Object o2) {
        if (SqlEvaluatorVisitor.isLong(o1)) {
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toLong(o1) * SqlEvaluatorVisitor.toLong(o2);
            }
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return new Double(o1.toString()) * SqlEvaluatorVisitor.toDouble(o2);
            }
            return null;
        }
        if (SqlEvaluatorVisitor.isDouble(o1)) {
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) * SqlEvaluatorVisitor.toDouble(o2);
            }
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) * new Double(o2.toString());
            }
            return null;
        }
        return null;
    }

    private static final Object divide(Object o1, Object o2) {
        if (SqlEvaluatorVisitor.isLong(o1)) {
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toLong(o1) / SqlEvaluatorVisitor.toLong(o2);
            }
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return new Double(o1.toString()) / SqlEvaluatorVisitor.toDouble(o2);
            }
            return null;
        }
        if (SqlEvaluatorVisitor.isDouble(o1)) {
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) / SqlEvaluatorVisitor.toDouble(o2);
            }
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) / new Double(o2.toString());
            }
            return null;
        }
        return null;
    }

    private static final Boolean in(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return null;
        }
        if (!(o1 instanceof String)) {
            return null;
        }
        List list = (List)o2;
        return list.contains((String)o1);
    }

    private static final Boolean greaterThan(Object o1, Object o2) {
        if (SqlEvaluatorVisitor.isLong(o1)) {
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toLong(o1) > SqlEvaluatorVisitor.toLong(o2);
            }
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return new Double(o1.toString()) > SqlEvaluatorVisitor.toDouble(o2);
            }
            return null;
        }
        if (SqlEvaluatorVisitor.isDouble(o1)) {
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) > SqlEvaluatorVisitor.toDouble(o2);
            }
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) > new Double(o2.toString());
            }
            return null;
        }
        return null;
    }

    private static final Boolean equals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return null;
        }
        if (o1 instanceof String) {
            return o1.equals(o2);
        }
        if (SqlEvaluatorVisitor.isBool(o1) && SqlEvaluatorVisitor.isBool(o2)) {
            return SqlEvaluatorVisitor.toBool(o1) == SqlEvaluatorVisitor.toBool(o2);
        }
        if (SqlEvaluatorVisitor.isLong(o1)) {
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toLong(o1) == SqlEvaluatorVisitor.toLong(o2);
            }
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return (double)SqlEvaluatorVisitor.toLong(o1) == SqlEvaluatorVisitor.toDouble(o2);
            }
        } else if (SqlEvaluatorVisitor.isDouble(o1)) {
            if (SqlEvaluatorVisitor.isLong(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) == (double)SqlEvaluatorVisitor.toLong(o2);
            }
            if (SqlEvaluatorVisitor.isDouble(o2)) {
                return SqlEvaluatorVisitor.toDouble(o1) == SqlEvaluatorVisitor.toDouble(o2);
            }
        }
        return false;
    }

    private static final boolean isNull(Object o) {
        return o == null;
    }

    private static final Boolean notBetween(Object o1, Object o2, Object o3) {
        return SqlEvaluatorVisitor.logicalOr(SqlEvaluatorVisitor.greaterThan(o2, o1), SqlEvaluatorVisitor.greaterThan(o1, o3));
    }

    private static final Object leafValue(SqlToken value, Map<String, Object> env) {
        switch (value.type()) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case FLOAT: {
                return value.getFloat();
            }
            case HEX: {
                return value.getHex();
            }
            case INT: {
                return value.getLong();
            }
            case LIST: {
                return value.getList();
            }
            case IDENT: {
                return env == null ? null : env.get(value.getIdent());
            }
            case STRING: {
                return value.getString();
            }
        }
        return null;
    }

    private static final Boolean logicalAnd(Object o1, Object o2) {
        if (SqlEvaluatorVisitor.isBool(o1) && !((Boolean)o1).booleanValue()) {
            return false;
        }
        if (SqlEvaluatorVisitor.isBool(o2) && !((Boolean)o2).booleanValue()) {
            return false;
        }
        if (SqlEvaluatorVisitor.isBool(o1) && ((Boolean)o1).booleanValue() && SqlEvaluatorVisitor.isBool(o2) && ((Boolean)o2).booleanValue()) {
            return true;
        }
        return null;
    }

    private static final Boolean logicalOr(Object o1, Object o2) {
        if (SqlEvaluatorVisitor.isBool(o1) && ((Boolean)o1).booleanValue()) {
            return true;
        }
        if (SqlEvaluatorVisitor.isBool(o2) && ((Boolean)o2).booleanValue()) {
            return true;
        }
        if (SqlEvaluatorVisitor.isBool(o1) && !((Boolean)o1).booleanValue() && SqlEvaluatorVisitor.isBool(o2) && !((Boolean)o2).booleanValue()) {
            return false;
        }
        return null;
    }

    private static final Boolean logicalNot(Object o) {
        return !SqlEvaluatorVisitor.isBool(o) ? null : Boolean.valueOf((Boolean)o == false);
    }

    private static final boolean isLong(Object o) {
        return o != null && o instanceof Long || o instanceof Integer;
    }

    private static final boolean isDouble(Object o) {
        return o != null && o instanceof Double || o instanceof Float;
    }

    private static final boolean isString(Object o) {
        return o != null && o instanceof String;
    }

    private static final boolean isBool(Object o) {
        return o != null && o instanceof Boolean;
    }

    private static final boolean isPattern(Object o) {
        return o != null && o instanceof Pattern;
    }
}

