/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.Multiples;
import com.rabbitmq.jms.parse.TokenStream;
import com.rabbitmq.jms.parse.sql.SqlToken;
import com.rabbitmq.jms.parse.sql.SqlTokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlTokenStream
implements TokenStream<SqlToken, Integer> {
    private static final Pattern JUNK_PATTERN = Pattern.compile("");
    private final List<SqlToken> tokenSequence;
    private final int tokenSequenceSize;
    private final CharSequence residue;
    private int currentPosition = 0;

    public SqlTokenStream(CharSequence cseq) {
        Multiples.Pair<List<SqlToken>, CharSequence> result = SqlTokenStream.tokenize(cseq);
        this.tokenSequence = result.left();
        this.tokenSequenceSize = result.left().size();
        this.residue = result.right();
    }

    public CharSequence getResidue() {
        return this.residue;
    }

    @Override
    public boolean moreTokens() {
        return this.currentPosition < this.tokenSequenceSize;
    }

    @Override
    public SqlToken readToken() {
        if (this.moreTokens()) {
            return this.tokenSequence.get(this.currentPosition);
        }
        return null;
    }

    @Override
    public SqlToken getNext() {
        SqlToken token = this.readToken();
        this.incrementPosition();
        return token;
    }

    private void incrementPosition() {
        if (this.currentPosition == this.tokenSequenceSize) {
            return;
        }
        ++this.currentPosition;
    }

    @Override
    public Integer position() {
        return this.currentPosition;
    }

    @Override
    public void stepBack() {
        if (this.currentPosition == 0) {
            return;
        }
        --this.currentPosition;
    }

    @Override
    public void reset(Integer position) {
        this.currentPosition = position < 0 ? 0 : (position < this.tokenSequenceSize ? position : this.tokenSequenceSize);
    }

    @Override
    public void reset() {
        this.currentPosition = 0;
    }

    private static final Multiples.Pair<List<SqlToken>, CharSequence> tokenize(CharSequence cseq) {
        ArrayList<SqlToken> tokenList = new ArrayList<SqlToken>();
        Matcher m = SqlTokenStream.getMatcher(cseq);
        int cseqIndex = 0;
        int cseqIndexNext = 0;
        int cseqLength = cseq.length();
        while ((cseqIndex = cseqIndexNext) < (cseqIndexNext = SqlTokenStream.matchFirstSqlTokenType(tokenList, m.region(cseqIndex, cseqLength))) && cseqIndexNext < cseqLength) {
        }
        return new Multiples.Pair<List<SqlToken>, CharSequence>(tokenList, cseq.subSequence(cseqIndexNext, cseqLength));
    }

    private static final int matchFirstSqlTokenType(List<SqlToken> tokenList, Matcher m) {
        for (SqlTokenType tt : SqlTokenType.values()) {
            Pattern ttPattern = tt.pattern();
            if (null == ttPattern) continue;
            m.usePattern(ttPattern);
            if (!m.lookingAt()) continue;
            if (tt.include()) {
                tokenList.add(new SqlToken(tt, m.group()));
            }
            return m.end();
        }
        return m.regionStart();
    }

    private static final Matcher getMatcher(CharSequence cseq) {
        return JUNK_PATTERN.matcher(cseq);
    }
}

