/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public abstract class UriCodec {
    private static final String DIGIT = "0123456789";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String SUB_DELIMS = "!$&'()*+,;=";
    private static final String UNRESERVED = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~";
    private static final String SCHEME_C = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-.";
    private static final String PCHAR_C = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:@";
    private static final String SEGMENT_C = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:@";
    private static final String PATH_C = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:@/";
    private static final String USERINFO_C = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:";
    private static final String HOST_C = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:[].";
    private static final byte[] SCHEME_C_BA = UriCodec.bytesOf("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-.");
    private static final byte[] USERINFO_C_BA = UriCodec.bytesOf("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:");
    private static final byte[] HOST_C_BA = UriCodec.bytesOf("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:[].");
    private static final byte[] PCHAR_C_BA = UriCodec.bytesOf("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:@");
    private static final byte[] SEGMENT_C_BA = PCHAR_C_BA;
    private static final byte[] PATH_C_BA = UriCodec.bytesOf("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~!$&'()*+,;=:@/");
    private static final char[] LOHEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HIHEX = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'B', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'D', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'E', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F', 'F'};

    private UriCodec() {
    }

    public static String encUserinfo(String ui, String encodingScheme) {
        return UriCodec.genericEncode(USERINFO_C_BA, ui, encodingScheme);
    }

    public static String decUserinfo(String rawui, String encodingScheme) {
        return UriCodec.genericDecode(rawui, encodingScheme);
    }

    public static String encScheme(String ui, String encodingScheme) {
        return UriCodec.genericEncode(SCHEME_C_BA, ui, encodingScheme);
    }

    public static String decScheme(String rawui, String encodingScheme) {
        return UriCodec.genericDecode(rawui, encodingScheme);
    }

    public static String encSegment(String ui, String encodingScheme) {
        return UriCodec.genericEncode(SEGMENT_C_BA, ui, encodingScheme);
    }

    public static String decSegment(String rawui, String encodingScheme) {
        return UriCodec.genericDecode(rawui, encodingScheme);
    }

    public static String encHost(String ui, String encodingScheme) {
        return UriCodec.genericEncode(HOST_C_BA, ui, encodingScheme);
    }

    public static String decHost(String rawui, String encodingScheme) {
        return UriCodec.genericDecode(rawui, encodingScheme);
    }

    public static String encPath(String ui, String encodingScheme) {
        return UriCodec.genericEncode(PATH_C_BA, ui, encodingScheme);
    }

    public static String decPath(String rawui, String encodingScheme) {
        return UriCodec.genericDecode(rawui, encodingScheme);
    }

    private static String genericDecode(String rawstr, String encodingScheme) {
        try {
            int starState = 0;
            int n = 0;
            int hiHex = 0;
            byte[] bytes = new byte[rawstr.length()];
            block7: for (byte b : rawstr.getBytes(encodingScheme)) {
                switch (starState) {
                    case 0: {
                        if (b != 37) {
                            bytes[n++] = b;
                            continue block7;
                        }
                        starState = 1;
                        continue block7;
                    }
                    case 1: {
                        starState = 2;
                        hiHex = UriCodec.hex(b);
                        continue block7;
                    }
                    case 2: {
                        starState = 0;
                        bytes[n++] = (byte)(hiHex * 16 + UriCodec.hex(b));
                        continue block7;
                    }
                }
            }
            return new String(bytes, 0, n, encodingScheme);
        }
        catch (UnsupportedEncodingException e) {
            return rawstr;
        }
    }

    private static int hex(int b) {
        return b < 48 ? 0 : (b < 58 ? b - 48 : (b < 65 ? 0 : (b < 71 ? b - 55 : (b < 97 ? 0 : (b < 103 ? b - 87 : 0)))));
    }

    private static String genericEncode(byte[] charClass, String str, String encodingScheme) {
        try {
            StringBuilder sb = new StringBuilder();
            for (byte b : str.getBytes(encodingScheme)) {
                if (UriCodec.inClass(b, charClass)) {
                    sb.append(Character.toChars(b));
                    continue;
                }
                UriCodec.addEscaped(sb, b);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    private static void addEscaped(StringBuilder sb, int b) {
        int ind = (b + 256) % 256;
        sb.append('%').append(HIHEX[ind]).append(LOHEX[ind]);
    }

    private static boolean inClass(byte b, byte[] sortedBytes) {
        return Arrays.binarySearch(sortedBytes, b) >= 0;
    }

    private static final byte[] bytesOf(String str) {
        try {
            byte[] result = str.getBytes("UTF-8");
            Arrays.sort(result, 0, result.length);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot generate byte array for URI conversion.", e);
        }
    }
}

