/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.RMQMessageConsumer;
import com.rabbitmq.jms.client.RMQSession;
import com.rabbitmq.jms.client.Subscriptions;
import com.rabbitmq.jms.parse.sql.SqlCompiler;
import com.rabbitmq.jms.parse.sql.SqlEvaluator;
import com.rabbitmq.jms.parse.sql.SqlExpressionType;
import com.rabbitmq.jms.parse.sql.SqlParser;
import com.rabbitmq.jms.parse.sql.SqlTokenStream;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.RMQJMSSelectorException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Subscription {
    static final Map<String, SqlExpressionType> JMS_TYPE_IDENTS = Subscription.generateJMSTypeIdents();
    private static final Logger LOGGER = LoggerFactory.getLogger(Subscription.class);
    private static final String RJMS_COMPILED_SELECTOR_ARG = "rjms_erlang_selector";
    private static final String RJMS_VERSION_ARG = "rjms_version";
    private final List<RMQMessageConsumer> consumers = new CopyOnWriteArrayList<RMQMessageConsumer>();
    private final Subscriptions subscriptions;
    public final String name;
    public final String queue;
    public final boolean durable;
    public final boolean shared;
    private final String selector;
    private final boolean noLocal;

    Subscription(String name, String queue, boolean durable, boolean shared, String selector, boolean noLocal) {
        this(null, name, queue, durable, shared, selector, noLocal);
    }

    Subscription(Subscriptions subscriptions, String name, String queue, boolean durable, boolean shared, String selector, boolean noLocal) {
        this.subscriptions = subscriptions;
        this.name = name;
        this.queue = queue;
        this.durable = durable;
        this.shared = shared;
        this.selector = selector;
        this.noLocal = noLocal;
    }

    private static boolean messageSelectorEquals(String selector1, String selector2) {
        if (selector1 == null && selector2 == null) {
            return true;
        }
        if (selector1 == null && selector2 != null) {
            return false;
        }
        if (selector1 != null && selector2 == null) {
            return false;
        }
        return selector1.equals(selector2);
    }

    private static boolean nullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    private static Map<String, SqlExpressionType> generateJMSTypeIdents() {
        HashMap<String, SqlExpressionType> map = new HashMap<String, SqlExpressionType>(6);
        map.put("JMSDeliveryMode", SqlExpressionType.STRING);
        map.put("JMSPriority", SqlExpressionType.ARITH);
        map.put("JMSMessageID", SqlExpressionType.STRING);
        map.put("JMSTimestamp", SqlExpressionType.ARITH);
        map.put("JMSCorrelationID", SqlExpressionType.STRING);
        map.put("JMSType", SqlExpressionType.STRING);
        return Collections.unmodifiableMap(map);
    }

    PostAction validateNewConsumer(Destination topic, boolean durable, boolean shared, String selector, boolean noLocal) throws JMSException {
        if (this.shared != shared) {
            throw new JMSException(String.format("The '%s' subscription already exists and is %s", this.name, this.shared ? "shared" : "unshared"));
        }
        if (this.durable != durable) {
            throw new IllegalArgumentException(String.format("Cannot validate a %s consumer in a %s subscription", durable ? "durable" : "non-durable", this.durable ? "durable" : "non-durable"));
        }
        PostAction postAction = this.durable ? (this.shared ? this.validateSharedDurable(topic, selector) : this.validateUnsharedDurable(topic, selector, noLocal)) : this.validateSharedNonDurable(topic, selector);
        return postAction;
    }

    private PostAction validateSharedDurable(Destination topic, String selector) throws JMSException {
        PostAction postAction = PostAction.NO_OP;
        if (!this.consumers.isEmpty()) {
            List closedConsumers;
            RMQDestination previousTopic;
            boolean atLeastOneActive;
            boolean bl = atLeastOneActive = this.consumers.stream().filter(c -> !c.isClosed()).count() > 0L;
            if (atLeastOneActive) {
                previousTopic = this.consumers.get(0).getDestination();
                if (!topic.equals(previousTopic) || !Subscription.messageSelectorEquals(selector, this.selector)) {
                    throw new JMSException(String.format("The '%s' subscription has at least 1 active consumer, a new consumer must have the same destination and the same message selector", this.name));
                }
            } else {
                previousTopic = this.consumers.get(0).getDestination();
                if (!topic.equals(previousTopic) || !Subscription.messageSelectorEquals(selector, this.selector)) {
                    postAction = c -> {
                        c.session.unsubscribe(this.name);
                        c.subscriptions.remove(this.durable, this.name);
                        c.subscriptions.register(this.name, this.queue, this.durable, this.shared, selector, this.noLocal);
                    };
                    this.consumers.clear();
                }
            }
            if (!(closedConsumers = this.consumers.stream().filter(c -> c.isClosed()).collect(Collectors.toList())).isEmpty()) {
                this.consumers.removeAll(closedConsumers);
            }
        }
        return postAction;
    }

    private PostAction validateUnsharedDurable(Destination topic, String selector, boolean noLocal) throws JMSException {
        PostAction postAction = PostAction.NO_OP;
        if (this.consumers.size() > 1) {
            throw new IllegalStateException(String.format("Subscription '%s' is unshared, it should not have %d consumers", this.name, this.consumers.size()));
        }
        if (this.consumers.size() == 1) {
            RMQMessageConsumer consumer = this.consumers.get(0);
            if (consumer.isClosed()) {
                RMQDestination previousTopic = consumer.getDestination();
                if (!topic.equals(previousTopic) || !Subscription.messageSelectorEquals(selector, this.selector) || noLocal != this.noLocal) {
                    postAction = c -> {
                        c.session.unsubscribe(this.name);
                        c.subscriptions.remove(this.durable, this.name);
                        c.subscriptions.register(this.name, this.queue, this.durable, this.shared, selector, noLocal);
                    };
                    this.consumers.remove(consumer);
                } else {
                    this.consumers.remove(consumer);
                }
            } else {
                throw new JMSException(String.format("The '%s' subscription has already 1 active consumer", this.name));
            }
        }
        return postAction;
    }

    private PostAction validateSharedNonDurable(Destination topic, String selector) throws JMSException {
        if (!this.shared) {
            throw new IllegalStateException("Unshared non-durable subscriptions are not supported by this module");
        }
        if (!this.consumers.isEmpty()) {
            RMQDestination previousTopic;
            boolean atLeastOneActive;
            boolean bl = atLeastOneActive = this.consumers.stream().filter(c -> !c.isClosed()).count() > 0L;
            if (!(!atLeastOneActive || topic.equals(previousTopic = this.consumers.get(0).getDestination()) && Subscription.messageSelectorEquals(selector, this.selector))) {
                throw new JMSException(String.format("The '%s' subscription has at least 1 active consumer, a new consumer must have the same destination and the same message selector", this.name));
            }
        }
        return PostAction.NO_OP;
    }

    void add(RMQMessageConsumer consumer) {
        this.consumers.add(consumer);
        if (this.shared && !this.durable) {
            consumer.addClosedListener(c -> {
                Subscriptions subscriptions = this.subscriptions;
                synchronized (subscriptions) {
                    this.consumers.remove(c);
                    if (this.consumers.isEmpty()) {
                        this.subscriptions.remove(this.durable, this.name);
                    }
                }
            });
        }
    }

    int consumerCount() {
        return this.consumers.size();
    }

    void createTopology(RMQDestination topic, RMQSession session, Channel channel) throws JMSException {
        if (this.consumers.isEmpty()) {
            try {
                session.declareRMQQueue(topic, this.queue, this.durable, false);
                if (Subscription.nullOrEmpty(this.selector)) {
                    channel.queueBind(this.queue, topic.getAmqpExchangeName(), topic.getAmqpRoutingKey());
                } else {
                    String selectionExchange = session.getSelectionExchange(this.durable);
                    channel.exchangeBind(selectionExchange, topic.getAmqpExchangeName(), topic.getAmqpRoutingKey());
                    this.bindSelectorQueue(channel, topic, this.selector, this.queue, selectionExchange);
                }
            }
            catch (IOException x) {
                LOGGER.error("consumer with tag '{}' could not be created", (Object)this.name, (Object)x);
                throw new RMQJMSException("RabbitMQ Exception creating Consumer", x);
            }
        }
    }

    private void bindSelectorQueue(Channel channel, RMQDestination dest, String jmsSelector, String queueName, String selectionExchange) throws InvalidSelectorException, IOException {
        SqlCompiler compiler = new SqlCompiler(new SqlEvaluator(new SqlParser(new SqlTokenStream(jmsSelector)), JMS_TYPE_IDENTS));
        if (!compiler.compileOk()) {
            throw new RMQJMSSelectorException(String.format("Selector expression failure: \"%s\".", jmsSelector));
        }
        HashMap<String, String> args = new HashMap<String, String>(5);
        args.put(RJMS_COMPILED_SELECTOR_ARG, compiler.compile());
        args.put(RJMS_VERSION_ARG, RMQSession.RJMS_CLIENT_VERSION);
        channel.queueBind(queueName, selectionExchange, dest.getAmqpRoutingKey(), args);
    }

    String queue() {
        return this.queue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return this.durable == that.durable && this.shared == that.shared && this.noLocal == that.noLocal && this.name.equals(that.name) && Objects.equals(this.selector, that.selector);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.durable, this.shared, this.selector, this.noLocal);
    }

    static class Context {
        private final RMQSession session;
        private final Subscriptions subscriptions;

        Context(RMQSession session, Subscriptions subscriptions) {
            this.session = session;
            this.subscriptions = subscriptions;
        }
    }

    @FunctionalInterface
    static interface PostAction {
        public static final PostAction NO_OP = c -> {};

        public void run(Context var1) throws JMSException;
    }
}

