/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports.converters;

import com.relevantcodes.extentreports.utils.FileReaderEx;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class TimeConverter {
    private static final String HOURS_PATTERN = "\\d+h";
    private static final String MINUTES_PATTERN = "\\d+m";
    private static final String SECONDS_PATTERN = "\\d+s";
    private static final String MILLIS_PATTERN = "\\d+ms";
    private Document doc;

    public long getLastRunDurationMillis() {
        String time;
        if (this.doc == null) {
            return 0L;
        }
        Elements totalTimeTakenCurrent = this.doc.select(".suite-total-time-current-value");
        Elements totalTimeTakenOverall = this.doc.select(".suite-total-time-overall-value");
        if (totalTimeTakenOverall != null && totalTimeTakenOverall.size() > 0 && !totalTimeTakenOverall.first().text().trim().equals("")) {
            time = totalTimeTakenOverall.first().text();
        } else if (totalTimeTakenCurrent != null && totalTimeTakenCurrent.size() > 0 && !totalTimeTakenCurrent.first().text().trim().equals("")) {
            time = totalTimeTakenCurrent.first().text();
        } else {
            return 0L;
        }
        try {
            int hours = Integer.parseInt(this.parseValue(this.parseValue(time, HOURS_PATTERN), "\\d+"));
            int minutes = Integer.parseInt(this.parseValue(this.parseValue(time, MINUTES_PATTERN), "\\d+"));
            int seconds = Integer.parseInt(this.parseValue(this.parseValue(time, SECONDS_PATTERN), "\\d+"));
            int millis = Integer.parseInt(this.parseValue(this.parseValue(time, MILLIS_PATTERN), "\\d+"));
            return millis += (3600 * hours + 60 * minutes + seconds) * 1000;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public TimeConverter(String filePath) {
        if (this.doc == null) {
            try {
                String source = FileReaderEx.readAllText(new File(filePath));
                this.doc = Jsoup.parse((String)source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String parseValue(String text, String format) {
        Pattern pattern = Pattern.compile(format);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }
}

