/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.asserts;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.salesforceiq.augmenteddriver.util.AugmentedFunctions;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;

public class AugmentedAssert {
    public static void assertElementIsPresentAfter(AugmentedFunctions driver, By by, int timeoutInSeconds) {
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(by);
        try {
            driver.findElementPresentAfter(by, timeoutInSeconds);
        }
        catch (TimeoutException e) {
            throw new AssertionError(String.format("Element %s is not present after %s seconds", by, timeoutInSeconds), e);
        }
    }

    public static void assertElementIsVisibleAfter(AugmentedFunctions driver, By by, int timeoutInSeconds) {
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(by);
        try {
            driver.findElementsVisibleAfter(by, timeoutInSeconds);
        }
        catch (TimeoutException e) {
            throw new AssertionError(String.format("Element %s is not visible after %s seconds", by, timeoutInSeconds), e);
        }
    }

    public static void assertElementIsClickableAfter(AugmentedFunctions driver, By by, int timeoutInSeconds) {
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(by);
        try {
            driver.findElementClickableAfter(by, timeoutInSeconds);
        }
        catch (TimeoutException e) {
            throw new AssertionError(String.format("Element %s is not clickable after %s seconds", by, timeoutInSeconds), e);
        }
    }

    public static void assertElementContainsAfter(AugmentedFunctions driver, By by, String text, int timeoutInSeconds) {
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(by);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text));
        try {
            driver.findElementContainAfter(by, text, timeoutInSeconds);
        }
        catch (TimeoutException e) {
            throw new AssertionError(String.format("Element %s does not contain %s after %s seconds", by, text, timeoutInSeconds), e);
        }
    }

    public static void assertElementIsNotVisibleAfter(AugmentedFunctions driver, By by, int timeoutInSeconds) {
        try {
            driver.findElementsVisibleAfter(by, timeoutInSeconds);
            Assert.fail(String.format("Element %s is visible", by));
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void assertElementIsNotClickableAfter(AugmentedFunctions driver, By by, int timeoutInSeconds) {
        try {
            driver.findElementClickableAfter(by, timeoutInSeconds);
            Assert.fail(String.format("Element %s is clickable", by));
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void assertElementIsNotPresentAfter(AugmentedFunctions driver, By by, int timeoutInSeconds) {
        try {
            driver.findElementPresentAfter(by, timeoutInSeconds);
            Assert.fail(String.format("Element %s is present", by));
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

