/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.guice;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.salesforceiq.augmenteddriver.guice.ExtraModules;
import com.salesforceiq.augmenteddriver.guice.GuiceModules;
import java.util.ArrayList;
import java.util.List;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class GuiceTestRunner
extends BlockJUnit4ClassRunner {
    private final transient Injector injector;

    public GuiceTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        List<Class<? extends AbstractModule>> modules = this.getGuiceModulesFor(klass);
        modules.addAll(this.getExtraModulesFor(klass));
        this.injector = this.createInjectorFor(modules);
    }

    @Override
    public final Object createTest() throws Exception {
        Object obj = super.createTest();
        this.injector.injectMembers(obj);
        return obj;
    }

    private Injector createInjectorFor(List<Class<? extends AbstractModule>> classes) throws InitializationError {
        ArrayList<AbstractModule> modules = Lists.newArrayList();
        for (Class<? extends AbstractModule> clazz : classes) {
            try {
                modules.add(clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        return Guice.createInjector(modules);
    }

    private List<Class<? extends AbstractModule>> getGuiceModulesFor(Class<?> klass) throws InitializationError {
        GuiceModules annotation = klass.getAnnotation(GuiceModules.class);
        if (annotation == null) {
            String message = String.format("Missing @GuiceModules annotation for unit test '%s'", klass.getName());
            throw new InitializationError(message);
        }
        return Lists.newArrayList(annotation.value());
    }

    private List<Class<? extends AbstractModule>> getExtraModulesFor(Class<?> klass) throws InitializationError {
        ExtraModules annotation = klass.getAnnotation(ExtraModules.class);
        return annotation == null ? Lists.newArrayList() : Lists.newArrayList(annotation.value());
    }
}

