/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.integrations;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.salesforceiq.augmenteddriver.integrations.Integration;
import com.salesforceiq.augmenteddriver.util.TestRunnerConfig;
import com.saucelabs.saucerest.SauceREST;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;

@Singleton
public class SauceLabsIntegration
implements Integration {
    private final SauceREST sauceRest;
    private final TestRunnerConfig arguments;

    @Inject
    public SauceLabsIntegration(SauceREST sauceREST, TestRunnerConfig arguments) {
        this.sauceRest = Preconditions.checkNotNull(sauceREST);
        this.arguments = Preconditions.checkNotNull(arguments);
    }

    public void jobName(String jobName, String sessionId) {
        this.update("name", jobName, sessionId);
    }

    public void testPassed(boolean testPassed, String sessionId) {
        this.update("passed", testPassed, sessionId);
    }

    public void buildName(String buildName, String sessionId) {
        this.update("build", buildName, sessionId);
    }

    public void uploadFile(Path fileToUpload, String destinationFileName) throws IOException {
        Preconditions.checkNotNull(fileToUpload);
        Preconditions.checkArgument(Files.exists(fileToUpload, new LinkOption[0]));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(destinationFileName));
        this.uploadFile(fileToUpload, destinationFileName, true);
    }

    public void uploadFile(Path fileToUpload, String destinationFileName, boolean overwrite) throws IOException {
        Preconditions.checkNotNull(fileToUpload);
        Preconditions.checkArgument(Files.exists(fileToUpload, new LinkOption[0]));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(destinationFileName));
        this.sauceRest.uploadFile(fileToUpload.toFile(), destinationFileName, overwrite);
    }

    private void update(String key, Object value, String sessionId) {
        if (this.isEnabled()) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(sessionId));
            Preconditions.checkArgument(!Strings.isNullOrEmpty(key));
            Preconditions.checkNotNull(value);
            HashMap<String, Object> updates = Maps.newHashMap();
            updates.put(key, value);
            this.sauceRest.updateJobInfo(sessionId, updates);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.arguments.sauce();
    }
}

