/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.integrations;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.salesforceiq.augmenteddriver.integrations.Integration;
import com.salesforceiq.augmenteddriver.reporters.TeamCityReporter;
import java.io.ByteArrayOutputStream;
import org.junit.runner.notification.RunListener;

@Singleton
public class TeamCityIntegration
implements Integration {
    private final boolean teamCityIntegration;

    @Inject
    public TeamCityIntegration(@Named(value="TEAM_CITY_INTEGRATION") String teamCityIntegration) {
        this.teamCityIntegration = Preconditions.checkNotNull(Boolean.valueOf(teamCityIntegration));
    }

    @Override
    public boolean isEnabled() {
        return this.teamCityIntegration;
    }

    public void printSessionId(String jobName, String sessionId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(sessionId));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(jobName));
        String message = String.format("SauceOnDemandSessionID=%1$s job-name=%2$s", sessionId, jobName);
        System.out.println(message);
    }

    public RunListener getReporter(ByteArrayOutputStream outputStream, String nameAppender) {
        Preconditions.checkNotNull(outputStream);
        Preconditions.checkNotNull(nameAppender);
        return new TeamCityReporter(outputStream, nameAppender);
    }
}

