/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.mobile.android;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.salesforceiq.augmenteddriver.mobile.AugmentedMobileFunctions;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidDriverProvider;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidElement;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidElementFactory;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidOnlyFunctions;
import com.salesforceiq.augmenteddriver.util.AugmentedFunctions;
import com.salesforceiq.augmenteddriver.util.MobileUtil;
import com.salesforceiq.augmenteddriver.util.WebDriverUtil;
import io.appium.java_client.AppiumDriver;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;

public class AugmentedAndroidFunctions
implements AugmentedFunctions<AugmentedAndroidElement>,
AugmentedMobileFunctions<AugmentedAndroidElement>,
AugmentedAndroidOnlyFunctions {
    private final int waitTimeInSeconds;
    private final AugmentedAndroidElementFactory augmentedAndroidElementFactory;
    private final SearchContext searchContext;
    private final AugmentedAndroidDriverProvider augmentedAndroidDriveProvider;

    @Inject
    public AugmentedAndroidFunctions(@Assisted SearchContext searchContext, @Named(value="WAIT_TIME_IN_SECONDS") String waitTimeInSeconds, AugmentedAndroidElementFactory augmentedAndroidElementFactory, AugmentedAndroidDriverProvider augmentedAndroidDriverProvider) {
        this.searchContext = Preconditions.checkNotNull(searchContext);
        this.augmentedAndroidDriveProvider = Preconditions.checkNotNull(augmentedAndroidDriverProvider);
        this.waitTimeInSeconds = Integer.valueOf(Preconditions.checkNotNull(waitTimeInSeconds));
        this.augmentedAndroidElementFactory = Preconditions.checkNotNull(augmentedAndroidElementFactory);
    }

    @Override
    public boolean isElementPresent(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementPresentAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public boolean isElementPresentAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        try {
            this.findElementPresentAfter(by, waitSeconds);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public boolean isElementPresentImmediate(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementPresentAfter(by, 0);
    }

    @Override
    public boolean isElementVisible(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementVisibleAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public boolean isElementVisibleAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        try {
            this.findElementsVisibleAfter(by, waitSeconds);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public boolean isElementVisibleImmediate(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementVisibleAfter(by, 0);
    }

    @Override
    public boolean isElementClickable(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementClickableAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public boolean isElementClickableAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        try {
            this.findElementClickableAfter(by, waitSeconds);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public boolean isElementClickableImmediate(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementClickableAfter(by, 0);
    }

    @Override
    public AugmentedAndroidElement findElementPresent(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementPresentAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedAndroidElement findElementPresentAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        return this.augmentedAndroidElementFactory.create(WebDriverUtil.findElementPresentAfter(this.searchContext, by, waitSeconds));
    }

    @Override
    public AugmentedAndroidElement findElementVisible(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementVisibleAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedAndroidElement findElementVisibleAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        return this.augmentedAndroidElementFactory.create(WebDriverUtil.findElementVisibleAfter(this.searchContext, by, waitSeconds));
    }

    @Override
    public AugmentedAndroidElement findElementClickable(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementClickableAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedAndroidElement findElementClickableAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        return this.augmentedAndroidElementFactory.create(WebDriverUtil.findElementClickableAfter(this.searchContext, by, waitSeconds));
    }

    @Override
    public AugmentedAndroidElement findElementNotMoving(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementNotMovingAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedAndroidElement findElementNotMovingAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        return this.augmentedAndroidElementFactory.create(WebDriverUtil.findElementNotMovingAfter(this.searchContext, by, waitSeconds));
    }

    @Override
    public AugmentedAndroidElement findElementContain(By by, String text) {
        return this.findElementContainAfter(by, text, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedAndroidElement findElementContainAfter(By by, String text, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text));
        return this.augmentedAndroidElementFactory.create(WebDriverUtil.findElementContainAfter(this.searchContext, by, text, waitInSeconds));
    }

    @Override
    public List<AugmentedAndroidElement> findElementsVisible(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementsVisibleAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public List<AugmentedAndroidElement> findElementsVisibleAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        return WebDriverUtil.findElementsVisibleAfter(this.searchContext, by, waitInSeconds).stream().map(webElement -> this.augmentedAndroidElementFactory.create((WebElement)webElement)).collect(Collectors.toList());
    }

    @Override
    public List<AugmentedAndroidElement> findElementsPresent(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementsPresentAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public List<AugmentedAndroidElement> findElementsPresentAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        return WebDriverUtil.findElementsVisibleAfter(this.searchContext, by, waitInSeconds).stream().map(webElement -> this.augmentedAndroidElementFactory.create((WebElement)webElement)).collect(Collectors.toList());
    }

    @Override
    public List<AugmentedAndroidElement> findElementsClickable(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementsClickableAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public List<AugmentedAndroidElement> findElementsClickableAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        return WebDriverUtil.findElementsClickableAfter(this.searchContext, by, waitInSeconds).stream().map(webElement -> this.augmentedAndroidElementFactory.create((WebElement)webElement)).collect(Collectors.toList());
    }

    @Override
    public void waitElementToNotBePresent(By by) {
        this.waitElementToNotBePresentAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public void waitElementToNotBePresentAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        WebDriverUtil.waitElementToNotBePresent(this.searchContext, by, waitInSeconds);
    }

    @Override
    public void waitElementToNotBeVisible(By by) {
        this.waitElementToNotBeVisibleAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public void waitElementToNotBeVisibleAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        WebDriverUtil.waitElementToNotBeVisible(this.searchContext, by, waitInSeconds);
    }

    @Override
    public AugmentedAndroidElement clickAndPresent(By click, By wait) {
        return this.clickAndPresentAfter(click, wait, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedAndroidElement clickAndPresentAfter(By click, By wait, int waitInSeconds) {
        Preconditions.checkNotNull(click);
        Preconditions.checkNotNull(wait);
        this.findElementClickableAfter(click, waitInSeconds).click();
        return this.findElementPresentAfter(wait, waitInSeconds);
    }

    @Override
    public void moveToAndClick(By moveTo, By click) {
        WebDriverUtil.moveToAndClick(this.augmentedAndroidDriveProvider.get(), moveTo, click, this.waitTimeInSeconds);
    }

    @Override
    public void moveToAndClickAfter(By moveTo, By click, int waitInSeconds) {
        WebDriverUtil.moveToAndClick(this.augmentedAndroidDriveProvider.get(), moveTo, click, waitInSeconds);
    }

    @Override
    public AugmentedAndroidElement moveTo(By moveTo) {
        return this.augmentedAndroidElementFactory.create(WebDriverUtil.moveTo(this.augmentedAndroidDriveProvider.get(), moveTo, this.waitTimeInSeconds));
    }

    @Override
    public AugmentedAndroidElement moveToAfter(By moveTo, int waitInSeconds) {
        return this.augmentedAndroidElementFactory.create(WebDriverUtil.moveTo(this.augmentedAndroidDriveProvider.get(), moveTo, waitInSeconds));
    }

    @Override
    public void clearAndSendKeys(By by, String text) {
        this.clearAndSendKeysAfter(by, text, this.waitTimeInSeconds);
    }

    @Override
    public void clearAndSendKeysAfter(By by, String text, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text));
        AugmentedAndroidElement element = this.findElementClickableAfter(by, waitInSeconds);
        element.clear();
        element.sendKeys(text);
    }

    @Override
    public AugmentedAndroidElement tap(By by) {
        Preconditions.checkNotNull(by);
        return this.tapAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedAndroidElement tapAfter(By by, int waitTimeInSeconds) {
        Preconditions.checkNotNull(by);
        WebElement element = MobileUtil.tap(this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), by, waitTimeInSeconds);
        return this.augmentedAndroidElementFactory.create(element);
    }

    @Override
    public AugmentedAndroidElement tap(By by, int offsetX, int offsetY) {
        Preconditions.checkNotNull(by);
        return this.tapAfter(by, offsetX, offsetY, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedAndroidElement tapAfter(By by, int offsetX, int offsetY, int waitTimeInSeconds) {
        Preconditions.checkNotNull(by);
        WebElement element = MobileUtil.tap(this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), by, offsetX, offsetY, waitTimeInSeconds);
        return this.augmentedAndroidElementFactory.create(element);
    }

    @Override
    public void tap(WebElement element, int pressInMilliSeconds) {
        Preconditions.checkNotNull(element);
        MobileUtil.tap(this.augmentedAndroidDriveProvider.get(), element, pressInMilliSeconds);
    }

    @Override
    public void clickAndSendKeys(By by, String keys) {
        this.clickAndSendKeysAfter(by, keys, this.waitTimeInSeconds);
    }

    @Override
    public void clickAndSendKeysAfter(By by, String keys, int waitInSeconds) {
        this.findElementClickableAfter(by, waitInSeconds).click();
        this.findElementClickableAfter(by, waitInSeconds).sendKeys(keys);
    }

    @Override
    public AugmentedAndroidElement swipeUpWaitElementVisible(By swipeUpElement, By elementPresent) {
        WebElement element = MobileUtil.swipeUpWaitVisible(this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), swipeUpElement, elementPresent);
        return this.augmentedAndroidElementFactory.create(element);
    }

    @Override
    public AugmentedAndroidElement swipeDownWaitElementVisible(By swipeUpElement, By elementPresent) {
        WebElement element = MobileUtil.swipeDownWaitVisible(this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), swipeUpElement, elementPresent);
        return this.augmentedAndroidElementFactory.create(element);
    }

    @Override
    public AugmentedAndroidElement swipeVerticalWaitVisible(By swipeElement, By elementVisible, int offset, int quantity, int duration) {
        WebElement element = MobileUtil.swipeVerticalWaitVisible(this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), swipeElement, elementVisible, offset, quantity, duration);
        return this.augmentedAndroidElementFactory.create(element);
    }

    @Override
    public void swipeUp(By swipeBy) {
        MobileUtil.swipeUp(this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), swipeBy);
    }

    @Override
    public void swipeDown(By swipeBy) {
        MobileUtil.swipeDown(this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), swipeBy);
    }

    @Override
    public void swipeVertical(By swipeBy, int offset, int duration) {
        MobileUtil.swipeVertical(this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), swipeBy, offset, duration);
    }

    @Override
    public void swipeFullRight(WebElement element) {
        this.swipeFullRightAfter(element, this.waitTimeInSeconds);
    }

    @Override
    public void swipeFullRight(By by) {
        this.swipeFullRightAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public void swipeFullRightAfter(WebElement element, int waitInSeconds) {
        MobileUtil.swipeFullRightAfter((AppiumDriver)this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), element, waitInSeconds);
    }

    @Override
    public void swipeFullRightAfter(By by, int waitInSeconds) {
        MobileUtil.swipeFullRightAfter((AppiumDriver)this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), by, waitInSeconds);
    }

    @Override
    public void swipeFullLeft(WebElement element) {
        this.swipeFullLeftAfter(element, this.waitTimeInSeconds);
    }

    @Override
    public void swipeFullLeft(By by) {
        this.swipeFullLeftAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public void swipeFullLeftAfter(WebElement element, int waitInSeconds) {
        MobileUtil.swipeFullLeftAfter((AppiumDriver)this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), element, waitInSeconds);
    }

    @Override
    public void swipeFullLeftAfter(By by, int waitInSeconds) {
        MobileUtil.swipeFullLeftAfter((AppiumDriver)this.augmentedAndroidDriveProvider.get(), this.augmentedAndroidDriveProvider.get().augmented(), by, waitInSeconds);
    }
}

