/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.mobile.android.pageobjects;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidDriver;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidElement;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidFunctions;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageObject;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageObjectActions;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageObjectActionsInterface;
import com.salesforceiq.augmenteddriver.util.PageObject;
import com.salesforceiq.augmenteddriver.util.PageObjectAssertionsInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AndroidPageContainerObject
implements AndroidPageObjectActionsInterface,
PageObjectAssertionsInterface,
PageObject {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidPageContainerObject.class);
    @Inject
    private Provider<AugmentedAndroidDriver> driverProvider;
    @Inject
    private AndroidPageObjectActions androidPageObjectActions;
    private AugmentedAndroidElement container;

    @Override
    public <T extends AndroidPageObject> T get(Class<T> clazz) {
        return this.androidPageObjectActions.get(clazz);
    }

    @Override
    public <T extends AndroidPageContainerObject> T get(Class<T> clazz, AugmentedAndroidElement container) {
        return this.androidPageObjectActions.get(clazz, container);
    }

    @Override
    public void assertPresent() {
        if (this.visibleBy().isPresent()) {
            this.container().augmented().findElementsVisible(this.visibleBy().get());
        }
    }

    @Override
    public AugmentedAndroidDriver driver() {
        return this.driverProvider.get();
    }

    @Override
    public AugmentedAndroidFunctions augmented() {
        return this.driverProvider.get().augmented();
    }

    void setContainer(AugmentedAndroidElement container) {
        this.container = container;
    }

    public AugmentedAndroidElement container() {
        return this.container;
    }
}

