/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.mobile.android.pageobjects;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidDriver;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidElement;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidFunctions;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageContainerObject;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageObject;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageObjectActionsInterface;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidPageObjectActions
implements AndroidPageObjectActionsInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidPageObjectActions.class);
    @Inject
    private Injector injector;
    @Inject
    private Provider<AugmentedAndroidDriver> driverProvider;

    @Override
    public <T extends AndroidPageObject> T get(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        AndroidPageObject instance = (AndroidPageObject)this.injector.getInstance(clazz);
        try {
            instance.assertPresent();
        }
        catch (AssertionError | TimeoutException e) {
            LOG.error(String.format("Page Object %s, not found, message: %s", clazz.getCanonicalName(), ((Throwable)e).getMessage()));
            throw e;
        }
        return (T)instance;
    }

    @Override
    public <T extends AndroidPageContainerObject> T get(Class<T> clazz, AugmentedAndroidElement container) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(container);
        AndroidPageContainerObject instance = (AndroidPageContainerObject)this.injector.getInstance(clazz);
        instance.setContainer(container);
        try {
            instance.assertPresent();
        }
        catch (AssertionError | TimeoutException e) {
            LOG.error(String.format("Page Object Container %s, not found, message: %s", clazz.getCanonicalName(), ((Throwable)e).getMessage()));
            throw e;
        }
        return (T)instance;
    }

    @Override
    public AugmentedAndroidDriver driver() {
        Preconditions.checkNotNull(this.driverProvider);
        return Preconditions.checkNotNull(this.driverProvider.get());
    }

    @Override
    public AugmentedAndroidFunctions augmented() {
        Preconditions.checkNotNull(this.driverProvider);
        Preconditions.checkNotNull(this.driverProvider.get());
        return Preconditions.checkNotNull(this.driverProvider.get().augmented());
    }
}

