/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.mobile.ios.pageobjects;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSDriver;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSElement;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSFunctions;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageObject;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageObjectActions;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageObjectActionsInterface;
import com.salesforceiq.augmenteddriver.util.PageObject;
import com.salesforceiq.augmenteddriver.util.PageObjectAssertionsInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOSPageContainerObject
implements IOSPageObjectActionsInterface,
PageObjectAssertionsInterface,
PageObject {
    private static final Logger LOG = LoggerFactory.getLogger(IOSPageContainerObject.class);
    @Inject
    private Provider<AugmentedIOSDriver> driverProvider;
    @Inject
    private IOSPageObjectActions IOSPageObjectActions;
    private AugmentedIOSElement container;

    @Override
    public <T extends IOSPageObject> T get(Class<T> clazz) {
        return this.IOSPageObjectActions.get(clazz);
    }

    @Override
    public <T extends IOSPageContainerObject> T get(Class<T> clazz, AugmentedIOSElement container) {
        return this.IOSPageObjectActions.get(clazz, container);
    }

    @Override
    public void assertPresent() {
        if (this.visibleBy().isPresent()) {
            this.container().augmented().findElementsVisible(this.visibleBy().get());
        }
    }

    @Override
    public AugmentedIOSDriver driver() {
        return this.driverProvider.get();
    }

    @Override
    public AugmentedIOSFunctions augmented() {
        return this.driverProvider.get().augmented();
    }

    void setContainer(AugmentedIOSElement container) {
        this.container = container;
    }

    public AugmentedIOSElement container() {
        return this.container;
    }
}

