/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.mobile.ios.pageobjects;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSDriver;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSElement;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSFunctions;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageContainerObject;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageObject;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageObjectActionsInterface;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOSPageObjectActions
implements IOSPageObjectActionsInterface {
    private static final Logger LOG = LoggerFactory.getLogger(IOSPageObjectActions.class);
    @Inject
    private Injector injector;
    @Inject
    private Provider<AugmentedIOSDriver> driverProvider;

    @Override
    public <T extends IOSPageObject> T get(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        IOSPageObject instance = (IOSPageObject)this.injector.getInstance(clazz);
        try {
            instance.assertPresent();
        }
        catch (AssertionError | TimeoutException e) {
            LOG.error(String.format("Page Object %s, not found, message: %s", clazz.getCanonicalName(), ((Throwable)e).getMessage()));
            throw e;
        }
        return (T)instance;
    }

    @Override
    public <T extends IOSPageContainerObject> T get(Class<T> clazz, AugmentedIOSElement container) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(container);
        IOSPageContainerObject instance = (IOSPageContainerObject)this.injector.getInstance(clazz);
        instance.setContainer(container);
        try {
            instance.assertPresent();
        }
        catch (AssertionError | TimeoutException e) {
            LOG.error(String.format("Page Object Container %s, not found, message: %s", clazz.getCanonicalName(), ((Throwable)e).getMessage()));
            throw e;
        }
        return (T)instance;
    }

    @Override
    public AugmentedIOSDriver driver() {
        Preconditions.checkNotNull(this.driverProvider);
        return Preconditions.checkNotNull(this.driverProvider.get());
    }

    @Override
    public AugmentedIOSFunctions augmented() {
        Preconditions.checkNotNull(this.driverProvider);
        Preconditions.checkNotNull(this.driverProvider.get());
        return Preconditions.checkNotNull(this.driverProvider.get().augmented());
    }
}

