/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.modules;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import com.salesforceiq.augmenteddriver.util.TestRunnerConfig;
import com.salesforceiq.augmenteddriver.util.Util;
import com.saucelabs.saucerest.SauceREST;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesModule.class);
    public static final String TEAM_CITY_INTEGRATION = "TEAM_CITY_INTEGRATION";
    public static final String REPORTING = "REPORTING";
    public static final String REMOTE_ADDRESS = "REMOTE_ADDRESS";
    public static final String UNIQUE_ID = "UNIQUE_ID";
    public static final String WAIT_IN_SECONDS = "WAIT_TIME_IN_SECONDS";
    public static final String MAX_RETRIES = "MAX_RETRIES";
    public static final String SAUCE_USER = "SAUCE_USER";
    public static final String SAUCE_KEY = "SAUCE_KEY";
    public static final String LOCAL_ADDRESS = "LOCAL_ADDRESS";
    public static final String SAUCE_ADDRESS = "SAUCE_ADDRESS";
    public static final String CAPABILITIES = "CAPABILITIES";
    public static final String SAUCE = "SAUCE";
    public static final String DEFAULT_CONFIG = "conf/augmented.properties";
    private static final String ID = Util.getRandomAsString();
    private static final Map<String, String> defaultProperties = new HashMap<String, String>(){
        {
            this.put(PropertiesModule.LOCAL_ADDRESS, "http://127.0.0.1:7777/wd/hub");
            this.put(PropertiesModule.SAUCE_ADDRESS, "http://ondemand.saucelabs.com:80/wd/hub");
            this.put(PropertiesModule.WAIT_IN_SECONDS, "30");
            this.put(PropertiesModule.TEAM_CITY_INTEGRATION, "false");
            this.put(PropertiesModule.REPORTING, "false");
            this.put(PropertiesModule.SAUCE_KEY, "");
            this.put(PropertiesModule.SAUCE_USER, "");
            this.put(PropertiesModule.MAX_RETRIES, "2");
        }
    };

    @Override
    protected void configure() {
        Properties properties = new Properties();
        defaultProperties.entrySet().stream().forEach(entry -> properties.setProperty((String)entry.getKey(), (String)entry.getValue()));
        String path = TestRunnerConfig.ARGUMENTS == null ? DEFAULT_CONFIG : TestRunnerConfig.ARGUMENTS.conf();
        Path propertiesPath = Paths.get(path, new String[0]);
        if (Files.exists(propertiesPath, new LinkOption[0])) {
            try {
                properties.load(new FileInputStream(propertiesPath.toFile()));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load properties file " + propertiesPath, e);
            }
        } else {
            throw new IllegalArgumentException("Properties file does not exist " + propertiesPath);
        }
        if (TestRunnerConfig.ARGUMENTS == null && properties.get(CAPABILITIES) != null) {
            TestRunnerConfig.initialize(properties);
        }
        if (TestRunnerConfig.ARGUMENTS == null) {
            throw new IllegalStateException("Capabilities were not loaded. Please set on properties file or command line args.");
        }
        if (TestRunnerConfig.ARGUMENTS.sauce()) {
            this.setSauceProperties(properties);
        } else {
            properties.setProperty(REMOTE_ADDRESS, properties.getProperty(LOCAL_ADDRESS));
        }
        Names.bindProperties(this.binder(), properties);
        if (TestRunnerConfig.ARGUMENTS.extra() != null && !TestRunnerConfig.ARGUMENTS.extra().isEmpty()) {
            Names.bindProperties(this.binder(), TestRunnerConfig.ARGUMENTS.extra());
        }
        this.bind(DesiredCapabilities.class).toInstance(TestRunnerConfig.ARGUMENTS.capabilities());
        this.bind(String.class).annotatedWith(Names.named(UNIQUE_ID)).toInstance(ID);
        this.bind(SauceREST.class).toInstance(new SauceREST(properties.getProperty(SAUCE_USER), properties.getProperty(SAUCE_KEY)));
    }

    private void setSauceProperties(Properties properties) {
        properties.setProperty(REMOTE_ADDRESS, properties.getProperty(SAUCE_ADDRESS));
        if (Strings.isNullOrEmpty(properties.getProperty(SAUCE_KEY))) {
            throw new IllegalArgumentException("To run on Sauce Labs, define SAUCE_KEY in the properties file");
        }
        if (Strings.isNullOrEmpty(properties.getProperty(SAUCE_USER))) {
            throw new IllegalArgumentException("To run on Sauce Labs, define SAUCE_USER in the properties file");
        }
        if (!Strings.isNullOrEmpty(TestRunnerConfig.ARGUMENTS.app())) {
            TestRunnerConfig.ARGUMENTS.capabilities().setCapability("app", "sauce-storage:" + TestRunnerConfig.ARGUMENTS.app());
        }
        TestRunnerConfig.ARGUMENTS.capabilities().setCapability("username", properties.getProperty(SAUCE_USER));
        TestRunnerConfig.ARGUMENTS.capabilities().setCapability("access-key", properties.getProperty(SAUCE_KEY));
    }
}

