/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.reporters;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.OutputStream;
import java.io.PrintStream;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class TeamCityReporter
extends RunListener {
    private final PrintStream out;
    private final String testNameAppender;
    private String currentTestClassName = null;
    private long startInMilliseconds;

    public TeamCityReporter(OutputStream out, String testNameAppender) {
        Preconditions.checkArgument(out != null, "out must not be null");
        this.testNameAppender = testNameAppender;
        this.out = new PrintStream(out);
        this.currentTestClassName = null;
    }

    @Override
    public void testStarted(Description description) {
        String testClassName = this.getTestClassName(description);
        String testName = this.getTestName(description, this.testNameAppender);
        if (this.currentTestClassName == null || !this.currentTestClassName.equals(testClassName)) {
            if (this.currentTestClassName != null) {
                this.out.println(String.format("##teamcity[testSuiteFinished name='%s']", this.currentTestClassName));
            }
            this.out.println(String.format("##teamcity[testSuiteStarted name='%s']", testClassName));
            this.currentTestClassName = testClassName;
        }
        this.startInMilliseconds = System.currentTimeMillis();
        this.out.println(String.format("##teamcity[testStarted name='%s' captureStandardOutput='true']", testName));
    }

    @Override
    public void testFinished(Description description) {
        String testName = this.getTestName(description, this.testNameAppender);
        this.out.println(String.format("##teamcity[testFinished name='%s' duration='%s']", testName, String.valueOf(System.currentTimeMillis() - this.startInMilliseconds)));
    }

    @Override
    public void testFailure(Failure failure) {
        if (failure.getTrace() != null && !failure.getTrace().isEmpty()) {
            this.out.print(failure.getTrace());
        }
        this.out.println(String.format("##teamcity[testFailed name='%s' message='%s' details='%s']", this.getTestName(failure.getDescription(), this.testNameAppender), "failed", ""));
    }

    @Override
    public void testIgnored(Description description) {
        this.out.println(String.format("##teamcity[testIgnored name='%s' message='%s']", this.getTestName(description, this.testNameAppender), ""));
    }

    @Override
    public void testRunFinished(Result result) {
        if (this.currentTestClassName != null) {
            this.out.println(String.format("##teamcity[testSuiteFinished name='%s']", this.currentTestClassName));
        }
    }

    protected String getTestClassName(Description description) {
        return description.getTestClass().getName();
    }

    protected String getTestName(Description description, String testNameAppender) {
        return description.getMethodName() + (Strings.isNullOrEmpty(testNameAppender) ? "" : "-" + testNameAppender);
    }
}

