/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.runners;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.salesforceiq.augmenteddriver.modules.CommandLineArgumentsModule;
import com.salesforceiq.augmenteddriver.modules.PropertiesModule;
import com.salesforceiq.augmenteddriver.modules.TestRunnerModule;
import com.salesforceiq.augmenteddriver.runners.AugmentedResult;
import com.salesforceiq.augmenteddriver.runners.TestRunnerFactory;
import com.salesforceiq.augmenteddriver.util.TestRunnerConfig;
import com.salesforceiq.augmenteddriver.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.runner.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TestMethodRunner
implements Callable<List<Result>> {
    private static final Logger LOG = LoggerFactory.getLogger(TestMethodRunner.class);
    private final Method method;
    private final int quantity;
    private final ListeningExecutorService executor;
    private final List<Result> results;
    private final int timeoutInMinutes;
    private final TestRunnerFactory testRunnerFactory;
    private final int parallel;

    @Inject
    public TestMethodRunner(TestRunnerConfig arguments, TestRunnerFactory testRunnerFactory) {
        this.method = Preconditions.checkNotNull(arguments.test());
        this.testRunnerFactory = Preconditions.checkNotNull(testRunnerFactory);
        this.quantity = arguments.quantity();
        this.results = Lists.newArrayList();
        this.parallel = arguments.parallel();
        this.executor = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(this.parallel));
        this.timeoutInMinutes = arguments.timeoutInMinutes();
    }

    @Override
    public List<Result> call() throws Exception {
        String testName = String.format("%s#%s", this.method.getDeclaringClass().getCanonicalName(), this.method.getName());
        long start = System.currentTimeMillis();
        LOG.info(String.format("STARTING TestMethodRunner %s, running it %s times %s in parallel", testName, this.quantity, this.parallel));
        for (int index = 0; index < this.quantity; ++index) {
            Util.pause(Util.getRandom(500, 2000));
            ListenableFuture<AugmentedResult> future = this.executor.submit(this.testRunnerFactory.create(this.method, String.valueOf(index)));
            Futures.addCallback(future, this.createCallback(this.method));
        }
        this.executor.awaitTermination(this.timeoutInMinutes, TimeUnit.MINUTES);
        LOG.info(String.format("FINISHED TestMethodRunner %s in %s", testName, Util.TO_PRETTY_FORNAT.apply(System.currentTimeMillis() - start)));
        return ImmutableList.copyOf(this.results);
    }

    private FutureCallback<AugmentedResult> createCallback(final Method method) {
        return new FutureCallback<AugmentedResult>(){

            @Override
            public void onSuccess(AugmentedResult result) {
                TestMethodRunner.this.results.add(result.getResult());
                LOG.info(String.format("Test %s finished of %s", TestMethodRunner.this.results.size(), TestMethodRunner.this.quantity));
                if (TestMethodRunner.this.results.size() == TestMethodRunner.this.quantity) {
                    TestMethodRunner.this.executor.shutdown();
                }
                this.processOutput(result.getOut());
            }

            @Override
            public void onFailure(Throwable t) {
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
                System.out.println("UNEXPECTED FAILURE");
                System.out.println(String.format("FAILED %s#%s", method.getDeclaringClass(), method.getName()));
                System.out.println("REASON: " + t.getMessage());
                System.out.println("STACKTRACE:");
                System.out.println(ExceptionUtils.getStackTrace(t));
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void processOutput(ByteArrayOutputStream outputStream) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    int oneByte;
                    while ((oneByte = inputStream.read()) != -1) {
                        System.out.write(oneByte);
                    }
                }
            }
        };
    }

    private static List<Result> failedTests(List<Result> results) {
        return results.stream().filter(result -> !result.wasSuccessful()).collect(Collectors.toList());
    }

    private static void checkArguments(TestRunnerConfig arguments) {
        Preconditions.checkNotNull(arguments.clazz(), "You should specify a class with -clazz parameter");
        Preconditions.checkNotNull(arguments.test(), "You should specify a test with -test parameter");
        Preconditions.checkNotNull(arguments.capabilities(), "You should specify capabilites with -capabilities parameter");
    }

    public static void main(String[] args) throws Exception {
        TestRunnerConfig arguments = TestRunnerConfig.initialize(args);
        TestMethodRunner.checkArguments(arguments);
        ArrayList<Module> modules = Lists.newArrayList(new CommandLineArgumentsModule(), new PropertiesModule(), new TestRunnerModule());
        Injector injector = Guice.createInjector(modules);
        TestMethodRunner runner = injector.getInstance(TestMethodRunner.class);
        Object results = runner.call();
        List<Result> failed = TestMethodRunner.failedTests((List<Result>)results);
        if (!failed.isEmpty()) {
            System.exit(1);
        }
    }
}

