/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.runners;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.salesforceiq.augmenteddriver.integrations.IntegrationFactory;
import com.salesforceiq.augmenteddriver.runners.AugmentedResult;
import com.salesforceiq.augmenteddriver.util.Util;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;

public class TestRunner
implements Callable<AugmentedResult> {
    private static final Log LOG = LogFactory.getLog(TestRunner.class);
    private final Method test;
    private final ByteArrayOutputStream outputStream;
    private final String nameAppender;
    private final IntegrationFactory integrationFactory;

    @Inject
    public TestRunner(@Assisted Method test, @Assisted String nameAppender, ByteArrayOutputStream outputStream, IntegrationFactory integrationFactory) {
        this.test = Preconditions.checkNotNull(test);
        this.nameAppender = Preconditions.checkNotNull(nameAppender);
        this.outputStream = Preconditions.checkNotNull(outputStream);
        this.integrationFactory = Preconditions.checkNotNull(integrationFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AugmentedResult call() throws Exception {
        JUnitCore jUnitCore = this.getJUnitCore();
        String testName = String.format("%s#%s", this.test.getDeclaringClass().getCanonicalName(), this.test.getName());
        long start = System.currentTimeMillis();
        try {
            LOG.info(String.format("STARTING Test %s", testName));
            Result result = jUnitCore.run(Request.method(this.test.getDeclaringClass(), this.test.getName()));
            LOG.info(String.format("FINSHED Test %s in %s", testName, Util.TO_PRETTY_FORNAT.apply(System.currentTimeMillis() - start)));
            AugmentedResult augmentedResult = new AugmentedResult(result, this.outputStream);
            return augmentedResult;
        }
        finally {
            this.outputStream.close();
        }
    }

    private JUnitCore getJUnitCore() {
        JUnitCore jUnitCore = new JUnitCore();
        if (this.integrationFactory.teamCity().isEnabled()) {
            jUnitCore.addListener(this.integrationFactory.teamCity().getReporter(this.outputStream, this.nameAppender));
        }
        return jUnitCore;
    }
}

