/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.runners;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.salesforceiq.augmenteddriver.modules.CommandLineArgumentsModule;
import com.salesforceiq.augmenteddriver.modules.PropertiesModule;
import com.salesforceiq.augmenteddriver.modules.TestRunnerModule;
import com.salesforceiq.augmenteddriver.runners.AugmentedResult;
import com.salesforceiq.augmenteddriver.runners.TestRunnerFactory;
import com.salesforceiq.augmenteddriver.util.Quarantine;
import com.salesforceiq.augmenteddriver.util.TestRunnerConfig;
import com.salesforceiq.augmenteddriver.util.TestsFinder;
import com.salesforceiq.augmenteddriver.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TestSuiteRunner
implements Callable<List<Result>> {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuiteRunner.class);
    private final TestRunnerFactory testRunnerFactory;
    private final List<String> suites;
    private final String suitesPackage;
    private final int timeoutInMinutes;
    private final ListeningExecutorService executor;
    private final List<Result> results;
    private final int maxRetries;
    private final int parallel;
    private final boolean quarantine;
    private int totalTests;
    private final Multiset<Method> countTests;

    @Inject
    public TestSuiteRunner(TestRunnerConfig arguments, TestRunnerFactory testRunnerFactory, @Named(value="MAX_RETRIES") String maxRetries) {
        this.testRunnerFactory = Preconditions.checkNotNull(testRunnerFactory);
        this.suites = arguments.suites();
        this.suitesPackage = arguments.suitesPackage();
        this.timeoutInMinutes = arguments.timeoutInMinutes();
        this.parallel = arguments.parallel();
        this.executor = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(this.parallel));
        this.totalTests = 0;
        this.maxRetries = Integer.valueOf(Preconditions.checkNotNull(maxRetries));
        this.quarantine = arguments.quarantine();
        this.results = Lists.newArrayList();
        this.countTests = HashMultiset.create();
    }

    @Override
    public List<Result> call() throws Exception {
        long start = System.currentTimeMillis();
        LOG.info(String.format("STARTING TestSuiteRunner for suites [%s], running %s tests in parallel", this.suites, this.parallel));
        List<Class> classesToTest = TestsFinder.getTestClassesOfPackage(this.suites, this.suitesPackage);
        LOG.info(String.format("Test Classes to run: %s", classesToTest));
        classesToTest.stream().forEach(test -> Lists.newArrayList(test.getMethods()).stream().filter(method -> method.isAnnotationPresent(Test.class) && !method.isAnnotationPresent(Ignore.class) && method.isAnnotationPresent(Quarantine.class) == this.quarantine).forEach(method -> {
            ++this.totalTests;
            Util.pause(Util.getRandom(500, 2000));
            ListenableFuture<AugmentedResult> future = this.executor.submit(this.testRunnerFactory.create((Method)method, ""));
            Futures.addCallback(future, this.createCallback((Method)method));
        }));
        LOG.info(String.format("Total tests running: %s", this.totalTests));
        this.executor.awaitTermination(this.timeoutInMinutes, TimeUnit.MINUTES);
        LOG.info(String.format("FINISHED TestSuiteRunner for suites [%s] in %s", this.suites, Util.TO_PRETTY_FORNAT.apply(System.currentTimeMillis() - start)));
        return ImmutableList.copyOf(this.results);
    }

    private FutureCallback<AugmentedResult> createCallback(final Method method) {
        return new FutureCallback<AugmentedResult>(){

            @Override
            public void onSuccess(AugmentedResult result) {
                TestSuiteRunner.this.countTests.add(method);
                if (result.getResult().wasSuccessful()) {
                    TestSuiteRunner.this.results.add(result.getResult());
                    LOG.info(String.format("Test %s finished of %s", TestSuiteRunner.this.results.size(), TestSuiteRunner.this.totalTests));
                    if (TestSuiteRunner.this.results.size() == TestSuiteRunner.this.totalTests) {
                        TestSuiteRunner.this.executor.shutdown();
                    }
                    this.processOutput(result.getOut());
                } else if (TestSuiteRunner.this.countTests.count(method) < TestSuiteRunner.this.maxRetries) {
                    LOG.info(String.format("Test %s#%s failed, retrying", method.getDeclaringClass().getCanonicalName(), method.getName()));
                    ListenableFuture<AugmentedResult> future = TestSuiteRunner.this.executor.submit(TestSuiteRunner.this.testRunnerFactory.create(method, ""));
                    Futures.addCallback(future, TestSuiteRunner.this.createCallback(method));
                } else {
                    TestSuiteRunner.this.results.add(result.getResult());
                    LOG.info(String.format("Test %s finished of %s", TestSuiteRunner.this.results.size(), TestSuiteRunner.this.totalTests));
                    if (TestSuiteRunner.this.results.size() == TestSuiteRunner.this.totalTests) {
                        TestSuiteRunner.this.executor.shutdown();
                    }
                    this.processOutput(result.getOut());
                }
            }

            @Override
            public void onFailure(Throwable t) {
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
                System.out.println("UNEXPECTED FAILURE");
                System.out.println(String.format("FAILED %s#%s", method.getDeclaringClass(), method.getName()));
                System.out.println("REASON: " + t.getMessage());
                System.out.println("STACKTRACE:");
                System.out.println(ExceptionUtils.getStackTrace(t));
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
                System.out.println("-------------------------------------------------------------");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void processOutput(ByteArrayOutputStream outputStream) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    int oneByte;
                    while ((oneByte = inputStream.read()) != -1) {
                        System.out.write(oneByte);
                    }
                }
            }
        };
    }

    private static List<Result> failedTests(List<Result> results) {
        return results.stream().filter(result -> !result.wasSuccessful()).collect(Collectors.toList());
    }

    private static void checkArguments(TestRunnerConfig arguments) {
        Preconditions.checkNotNull(arguments.suites(), "There should be at least one suite passed in the -suites argument");
        Preconditions.checkArgument(!arguments.suites().isEmpty(), "There should be at least one suite passed in the -suites argument");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(arguments.suitesPackage()), "-suitesPackage should be defined");
        Preconditions.checkNotNull(arguments.capabilities(), "You should specify capabilites with -capabilities parameter");
    }

    public static void main(String[] args) throws Exception {
        TestRunnerConfig arguments = TestRunnerConfig.initialize(args);
        TestSuiteRunner.checkArguments(arguments);
        ArrayList<Module> modules = com.google.common.collect.Lists.newArrayList(new CommandLineArgumentsModule(), new PropertiesModule(), new TestRunnerModule());
        Injector injector = Guice.createInjector(modules);
        TestSuiteRunner runner = injector.getInstance(TestSuiteRunner.class);
        Object results = runner.call();
        List<Result> failed = TestSuiteRunner.failedTests((List<Result>)results);
        if (!failed.isEmpty()) {
            System.exit(1);
        }
    }
}

