/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.testcases;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import com.salesforceiq.augmenteddriver.asserts.AugmentedAssert;
import com.salesforceiq.augmenteddriver.guice.GuiceModules;
import com.salesforceiq.augmenteddriver.integrations.IntegrationFactory;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidDriver;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidDriverProvider;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidElement;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidFunctions;
import com.salesforceiq.augmenteddriver.mobile.android.AugmentedAndroidFunctionsFactory;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageContainerObject;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageObject;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageObjectActions;
import com.salesforceiq.augmenteddriver.mobile.android.pageobjects.AndroidPageObjectActionsInterface;
import com.salesforceiq.augmenteddriver.modules.AugmentedAndroidDriverModule;
import com.salesforceiq.augmenteddriver.modules.PropertiesModule;
import com.salesforceiq.augmenteddriver.testcases.AugmentedBaseTestCase;
import com.salesforceiq.augmenteddriver.util.TestRunnerConfig;
import com.salesforceiq.augmenteddriver.util.Util;
import java.net.MalformedURLException;
import org.junit.After;
import org.junit.Before;
import org.openqa.selenium.By;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GuiceModules(value={PropertiesModule.class, AugmentedAndroidDriverModule.class})
public class AugmentedAndroidTestCase
extends AugmentedBaseTestCase
implements AndroidPageObjectActionsInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AugmentedAndroidTestCase.class);
    private AugmentedAndroidDriver driver;
    @Inject
    private AugmentedAndroidDriverProvider augmentedAndroidDriverProvider;
    @Inject
    private AugmentedAndroidFunctionsFactory augmentedAndroidFunctionsFactory;
    private AugmentedAndroidFunctions augmentedAndroidFunctions;
    @Named(value="REMOTE_ADDRESS")
    @Inject
    private String remoteAddress;
    @Inject
    private DesiredCapabilities capabilities;
    @Inject
    private AndroidPageObjectActions androidPageObjectActions;
    @Inject
    private IntegrationFactory integrations;
    @Inject
    private TestRunnerConfig arguments;
    @Inject
    private Injector injector;

    @Before
    public void setUp() throws MalformedURLException {
        Preconditions.checkNotNull(this.augmentedAndroidDriverProvider);
        Preconditions.checkNotNull(this.integrations);
        Preconditions.checkNotNull(this.arguments);
        Preconditions.checkNotNull(this.androidPageObjectActions);
        Preconditions.checkNotNull(this.remoteAddress);
        Preconditions.checkNotNull(this.capabilities);
        long start = System.currentTimeMillis();
        LOG.info("Creating AugmentedAndroidDriver");
        try {
            this.driver = new AugmentedAndroidDriver(this.remoteAddress, this.capabilities, this.augmentedAndroidFunctions);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Check your addresses on the properties file", e);
        }
        this.augmentedAndroidFunctions = this.augmentedAndroidFunctionsFactory.create(this.driver);
        this.driver.setAugmentedFunctions(this.augmentedAndroidFunctions);
        this.augmentedAndroidDriverProvider.set(this.driver);
        LOG.info("AugmentedAndroidDriver created in " + Util.TO_PRETTY_FORNAT.apply(System.currentTimeMillis() - start));
        this.sessionId = this.driver.getSessionId().toString();
        if (this.integrations.sauceLabs().isEnabled()) {
            this.integrations.sauceLabs().jobName(this.getFullTestName(), this.sessionId);
            this.integrations.sauceLabs().buildName(this.getUniqueId(), this.sessionId);
        }
        if (this.integrations.teamCity().isEnabled() && this.integrations.sauceLabs().isEnabled()) {
            this.integrations.teamCity().printSessionId(this.getFullTestName(), this.sessionId);
        }
    }

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.quit();
        }
    }

    @Override
    public AugmentedAndroidDriver driver() {
        return Preconditions.checkNotNull(this.driver);
    }

    @Override
    public AugmentedAndroidFunctions augmented() {
        return Preconditions.checkNotNull(this.augmentedAndroidFunctions);
    }

    @Override
    public <T extends AndroidPageObject> T get(Class<T> clazz) {
        return this.androidPageObjectActions.get(clazz);
    }

    @Override
    public <T extends AndroidPageContainerObject> T get(Class<T> clazz, AugmentedAndroidElement container) {
        return this.androidPageObjectActions.get(clazz, container);
    }

    @Override
    public void assertElementIsPresentAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsPresentAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsPresent(By by) {
        AugmentedAssert.assertElementIsPresentAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsVisibleAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsVisibleAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsVisible(By by) {
        AugmentedAssert.assertElementIsVisibleAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsClickableAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsClickableAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsClickable(By by) {
        AugmentedAssert.assertElementIsClickableAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementContainsAfter(By by, String text, int timeoutInSeconds) {
        AugmentedAssert.assertElementContainsAfter(this.augmented(), by, text, timeoutInSeconds);
    }

    @Override
    public void assertElementContains(By by, String text) {
        AugmentedAssert.assertElementContainsAfter(this.augmented(), by, text, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotClickableAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotClickableAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotClickable(By by) {
        AugmentedAssert.assertElementIsNotClickableAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotVisibleAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotVisibleAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotVisible(By by) {
        AugmentedAssert.assertElementIsNotVisibleAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotPresentAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotPresentAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotPresent(By by) {
        AugmentedAssert.assertElementIsNotPresentAfter(this.augmented(), by, this.waitTimeInSeconds());
    }
}

