/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.testcases;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.salesforceiq.augmenteddriver.asserts.AugmentedAssertInterface;
import com.salesforceiq.augmenteddriver.guice.GuiceTestRunner;
import com.salesforceiq.augmenteddriver.integrations.IntegrationFactory;
import com.salesforceiq.augmenteddriver.util.TestRunnerConfig;
import com.salesforceiq.augmenteddriver.util.Util;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.openqa.selenium.remote.DesiredCapabilities;

@RunWith(value=GuiceTestRunner.class)
public abstract class AugmentedBaseTestCase
implements AugmentedAssertInterface {
    @Rule
    public TestName testName = new TestName();
    @Inject
    @Named(value="WAIT_TIME_IN_SECONDS")
    private String waitTimeInSeconds;
    @Inject
    @Named(value="UNIQUE_ID")
    private String uniqueId;
    @Inject
    private DesiredCapabilities capabilities;
    @Inject
    private IntegrationFactory integrations;
    @Inject
    private TestRunnerConfig arguments;
    protected String sessionId;
    @Rule
    public TestWatcher testWatcher = new TestWatcher(){

        @Override
        protected void failed(Throwable e, Description description) {
            if (AugmentedBaseTestCase.this.integrations.sauceLabs().isEnabled() && !Strings.isNullOrEmpty(AugmentedBaseTestCase.this.sessionId)) {
                AugmentedBaseTestCase.this.integrations.sauceLabs().testPassed(false, AugmentedBaseTestCase.this.sessionId);
            }
        }

        @Override
        protected void succeeded(Description description) {
            if (AugmentedBaseTestCase.this.integrations.sauceLabs().isEnabled() && !Strings.isNullOrEmpty(AugmentedBaseTestCase.this.sessionId)) {
                AugmentedBaseTestCase.this.integrations.sauceLabs().testPassed(true, AugmentedBaseTestCase.this.sessionId);
            }
        }
    };

    protected int waitTimeInSeconds() {
        return Integer.valueOf(this.waitTimeInSeconds);
    }

    protected String getUniqueId() {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(this.uniqueId));
        return this.uniqueId;
    }

    protected String getFullTestName() {
        return String.format("%s:%s:%s", this.getUniqueId(), Util.shortenClass(this.getClass()), this.testName.getMethodName());
    }

    protected String getTestName() {
        return this.testName.getMethodName();
    }
}

