/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.testcases;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.salesforceiq.augmenteddriver.asserts.AugmentedAssert;
import com.salesforceiq.augmenteddriver.guice.GuiceModules;
import com.salesforceiq.augmenteddriver.integrations.IntegrationFactory;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSDriver;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSDriverProvider;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSElement;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSFunctions;
import com.salesforceiq.augmenteddriver.mobile.ios.AugmentedIOSFunctionsFactory;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageContainerObject;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageObject;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageObjectActions;
import com.salesforceiq.augmenteddriver.mobile.ios.pageobjects.IOSPageObjectActionsInterface;
import com.salesforceiq.augmenteddriver.modules.AugmentedIOSDriverModule;
import com.salesforceiq.augmenteddriver.modules.PropertiesModule;
import com.salesforceiq.augmenteddriver.testcases.AugmentedBaseTestCase;
import com.salesforceiq.augmenteddriver.util.TestRunnerConfig;
import com.salesforceiq.augmenteddriver.util.Util;
import java.net.MalformedURLException;
import org.junit.After;
import org.junit.Before;
import org.openqa.selenium.By;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GuiceModules(value={PropertiesModule.class, AugmentedIOSDriverModule.class})
public class AugmentedIOSTestCase
extends AugmentedBaseTestCase
implements IOSPageObjectActionsInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AugmentedIOSTestCase.class);
    private AugmentedIOSDriver driver;
    @Inject
    private AugmentedIOSFunctionsFactory augmentedIOSFunctionsFactory;
    private AugmentedIOSFunctions augmentedIOSFunctions;
    @Inject
    private AugmentedIOSDriverProvider augmentedIOSDriverProvider;
    @Inject
    private IOSPageObjectActions iosPageObjectActions;
    @Inject
    private IntegrationFactory integrations;
    @Inject
    private TestRunnerConfig arguments;
    @Named(value="REMOTE_ADDRESS")
    @Inject
    private String remoteAddress;
    @Inject
    private DesiredCapabilities capabilities;

    @Before
    public void setUp() {
        Preconditions.checkNotNull(this.augmentedIOSDriverProvider);
        Preconditions.checkNotNull(this.integrations);
        Preconditions.checkNotNull(this.arguments);
        Preconditions.checkNotNull(this.iosPageObjectActions);
        Preconditions.checkNotNull(this.remoteAddress);
        Preconditions.checkNotNull(this.capabilities);
        long start = System.currentTimeMillis();
        LOG.info("Creating AugmentedIOSDriver");
        try {
            this.driver = new AugmentedIOSDriver(this.remoteAddress, this.capabilities, this.augmentedIOSFunctions);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Check your addresses on the properties file", e);
        }
        this.augmentedIOSFunctions = this.augmentedIOSFunctionsFactory.create(this.driver);
        this.driver.setAugmentedFunctions(this.augmentedIOSFunctions);
        this.augmentedIOSDriverProvider.set(this.driver);
        LOG.info("AugmentedIOSDriver created in " + Util.TO_PRETTY_FORNAT.apply(System.currentTimeMillis() - start));
        this.sessionId = this.driver.getSessionId().toString();
        if (this.integrations.sauceLabs().isEnabled()) {
            this.integrations.sauceLabs().jobName(this.getFullTestName(), this.sessionId);
            this.integrations.sauceLabs().buildName(this.getUniqueId(), this.sessionId);
        }
        if (this.integrations.teamCity().isEnabled() && this.integrations.sauceLabs().isEnabled()) {
            this.integrations.teamCity().printSessionId(this.getFullTestName(), this.sessionId);
        }
    }

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.quit();
        }
    }

    @Override
    public AugmentedIOSDriver driver() {
        return Preconditions.checkNotNull(this.driver);
    }

    @Override
    public AugmentedIOSFunctions augmented() {
        return Preconditions.checkNotNull(this.augmentedIOSFunctions);
    }

    @Override
    public <T extends IOSPageObject> T get(Class<T> clazz) {
        return this.iosPageObjectActions.get(clazz);
    }

    @Override
    public <T extends IOSPageContainerObject> T get(Class<T> clazz, AugmentedIOSElement container) {
        return this.iosPageObjectActions.get(clazz, container);
    }

    @Override
    public void assertElementIsPresentAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsPresentAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsPresent(By by) {
        AugmentedAssert.assertElementIsPresentAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsVisibleAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsVisibleAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsVisible(By by) {
        AugmentedAssert.assertElementIsVisibleAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsClickableAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsClickableAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsClickable(By by) {
        AugmentedAssert.assertElementIsClickableAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementContainsAfter(By by, String text, int timeoutInSeconds) {
        AugmentedAssert.assertElementContainsAfter(this.augmented(), by, text, timeoutInSeconds);
    }

    @Override
    public void assertElementContains(By by, String text) {
        AugmentedAssert.assertElementContainsAfter(this.augmented(), by, text, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotClickableAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotClickableAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotClickable(By by) {
        AugmentedAssert.assertElementIsNotClickableAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotVisibleAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotVisibleAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotVisible(By by) {
        AugmentedAssert.assertElementIsNotVisibleAfter(this.augmented(), by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotPresentAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotPresentAfter(this.augmented(), by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotPresent(By by) {
        AugmentedAssert.assertElementIsNotPresentAfter(this.augmented(), by, this.waitTimeInSeconds());
    }
}

