/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.testcases;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.salesforceiq.augmenteddriver.asserts.AugmentedAssert;
import com.salesforceiq.augmenteddriver.guice.GuiceModules;
import com.salesforceiq.augmenteddriver.integrations.IntegrationFactory;
import com.salesforceiq.augmenteddriver.modules.AugmentedWebDriverModule;
import com.salesforceiq.augmenteddriver.modules.PropertiesModule;
import com.salesforceiq.augmenteddriver.testcases.AugmentedBaseTestCase;
import com.salesforceiq.augmenteddriver.util.TestRunnerConfig;
import com.salesforceiq.augmenteddriver.util.Util;
import com.salesforceiq.augmenteddriver.web.AugmentedWebDriver;
import com.salesforceiq.augmenteddriver.web.AugmentedWebDriverProvider;
import com.salesforceiq.augmenteddriver.web.AugmentedWebElement;
import com.salesforceiq.augmenteddriver.web.AugmentedWebFunctions;
import com.salesforceiq.augmenteddriver.web.AugmentedWebFunctionsFactory;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageContainerObject;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageObject;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageObjectActions;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageObjectActionsInterface;
import java.net.MalformedURLException;
import org.junit.After;
import org.junit.Before;
import org.openqa.selenium.By;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GuiceModules(value={PropertiesModule.class, AugmentedWebDriverModule.class})
public class AugmentedWebTestCase
extends AugmentedBaseTestCase
implements WebPageObjectActionsInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AugmentedWebTestCase.class);
    private AugmentedWebDriver driver;
    @Inject
    private AugmentedWebDriverProvider augmentedWebDriverProvider;
    @Inject
    private AugmentedWebFunctionsFactory augmentedWebFunctionsFactory;
    private AugmentedWebFunctions augmentedWebFunctions;
    @Inject
    private WebPageObjectActions webPageObjectActions;
    @Inject
    private IntegrationFactory integrations;
    @Inject
    private TestRunnerConfig arguments;
    @Named(value="REMOTE_ADDRESS")
    @Inject
    private String remoteAddress;
    @Inject
    private DesiredCapabilities capabilities;

    @Override
    public AugmentedWebDriver driver() {
        return Preconditions.checkNotNull(this.driver);
    }

    @Override
    public AugmentedWebFunctions augmented() {
        return Preconditions.checkNotNull(this.augmentedWebFunctions);
    }

    @Override
    public <T extends WebPageObject> T get(Class<T> clazz) {
        return this.webPageObjectActions.get(clazz);
    }

    @Override
    public <T extends WebPageContainerObject> T get(Class<T> clazz, AugmentedWebElement container) {
        return this.webPageObjectActions.get(clazz, container);
    }

    @Before
    public void setUp() {
        Preconditions.checkNotNull(this.augmentedWebDriverProvider);
        Preconditions.checkNotNull(this.augmentedWebFunctionsFactory);
        Preconditions.checkNotNull(this.integrations);
        Preconditions.checkNotNull(this.arguments);
        Preconditions.checkNotNull(this.webPageObjectActions);
        Preconditions.checkNotNull(this.remoteAddress);
        Preconditions.checkNotNull(this.capabilities);
        long start = System.currentTimeMillis();
        LOG.info("Creating AugmentedWebDriver");
        try {
            this.driver = new AugmentedWebDriver(this.remoteAddress, this.capabilities);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Check your addresses on the properties file", e);
        }
        this.augmentedWebFunctions = this.augmentedWebFunctionsFactory.create(this.driver);
        this.driver.setAugmentedFunctions(this.augmentedWebFunctions);
        this.augmentedWebDriverProvider.set(this.driver);
        LOG.info("AugmentedWebDriver created in " + Util.TO_PRETTY_FORNAT.apply(System.currentTimeMillis() - start));
        this.sessionId = this.driver.getSessionId().toString();
        if (this.integrations.sauceLabs().isEnabled()) {
            this.integrations.sauceLabs().jobName(this.getFullTestName(), this.sessionId);
            this.integrations.sauceLabs().buildName(this.getUniqueId(), this.sessionId);
        }
        if (this.integrations.teamCity().isEnabled() && this.integrations.sauceLabs().isEnabled()) {
            this.integrations.teamCity().printSessionId(this.getFullTestName(), this.sessionId);
        }
    }

    @After
    public void tearDown() {
        if (this.driver != null) {
            this.driver.quit();
        }
    }

    @Override
    public void assertElementIsPresentAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsPresentAfter(this.augmentedWebFunctions, by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsPresent(By by) {
        AugmentedAssert.assertElementIsPresentAfter(this.augmentedWebFunctions, by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsVisibleAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsVisibleAfter(this.augmentedWebFunctions, by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsVisible(By by) {
        AugmentedAssert.assertElementIsVisibleAfter(this.augmentedWebFunctions, by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsClickableAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsClickableAfter(this.augmentedWebFunctions, by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsClickable(By by) {
        AugmentedAssert.assertElementIsClickableAfter(this.augmentedWebFunctions, by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementContainsAfter(By by, String text, int timeoutInSeconds) {
        AugmentedAssert.assertElementContainsAfter(this.augmentedWebFunctions, by, text, timeoutInSeconds);
    }

    @Override
    public void assertElementContains(By by, String text) {
        AugmentedAssert.assertElementContainsAfter(this.augmentedWebFunctions, by, text, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotClickableAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotClickableAfter(this.augmentedWebFunctions, by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotClickable(By by) {
        AugmentedAssert.assertElementIsNotClickableAfter(this.augmentedWebFunctions, by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotVisibleAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotVisibleAfter(this.augmentedWebFunctions, by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotVisible(By by) {
        AugmentedAssert.assertElementIsNotVisibleAfter(this.augmentedWebFunctions, by, this.waitTimeInSeconds());
    }

    @Override
    public void assertElementIsNotPresentAfter(By by, int timeoutInSeconds) {
        AugmentedAssert.assertElementIsNotPresentAfter(this.augmentedWebFunctions, by, timeoutInSeconds);
    }

    @Override
    public void assertElementIsNotPresent(By by) {
        AugmentedAssert.assertElementIsNotPresentAfter(this.augmentedWebFunctions, by, this.waitTimeInSeconds());
    }
}

