/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.util;

import com.google.common.base.Preconditions;
import com.salesforceiq.augmenteddriver.util.AugmentedFunctions;
import io.appium.java_client.AppiumDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebElement;

public class MobileUtil {
    private static final int VERTICAL_OFFSET = 10;
    private static final int BIG_NUMBER = 9999999;
    private static final int DEFAULT_DURATION = 1000;
    private static final int DEFAULT_TAP_DURATION = 500;

    public static WebElement swipeUpWaitVisible(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By swipeElement, By elementVisible) {
        return MobileUtil.swipeVerticalWaitVisible(driver, augmentedFunctions, swipeElement, elementVisible, -9999999, 5, 1000);
    }

    public static WebElement tap(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By by, int waitTimeInSeconds) {
        Object element = augmentedFunctions.findElementPresentAfter(by, waitTimeInSeconds);
        MobileUtil.tap(driver, element, 500);
        return element;
    }

    public static WebElement tap(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By by, int offsetX, int offsetY, int waitTimeInSeconds) {
        Object element = augmentedFunctions.findElementPresentAfter(by, waitTimeInSeconds);
        driver.tap(1, element.getLocation().getX() + offsetX, element.getLocation().getY() + offsetY, 500);
        return element;
    }

    public static void tap(AppiumDriver driver, WebElement element, int pressInMilliSeconds) {
        driver.tap(1, element.getLocation().getX(), element.getLocation().getY(), pressInMilliSeconds);
    }

    public static WebElement swipeDownWaitVisible(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By swipeElement, By elementVisible) {
        return MobileUtil.swipeVerticalWaitVisible(driver, augmentedFunctions, swipeElement, elementVisible, 9999999, 5, 1000);
    }

    public static void swipeUp(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By swipeBy) {
        MobileUtil.swipeVertical(driver, augmentedFunctions, swipeBy, -9999999, 1000);
    }

    public static void swipeDown(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By swipeBy) {
        MobileUtil.swipeVertical(driver, augmentedFunctions, swipeBy, 9999999, 1000);
    }

    public static void swipeVertical(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By swipeBy, int offset, int duration) {
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(augmentedFunctions);
        Preconditions.checkNotNull(swipeBy);
        Object elementPresent = augmentedFunctions.findElementPresent(swipeBy);
        int x = elementPresent.getLocation().getX() + elementPresent.getSize().getWidth() / 2;
        int y = elementPresent.getLocation().getY() + elementPresent.getSize().getHeight() / 2;
        int swipe = MobileUtil.getVerticalOffset(driver, y, offset);
        driver.swipe(x, y, x, swipe, duration);
    }

    public static WebElement swipeVerticalWaitVisible(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By swipeElement, By elementVisible, int offset, int quantity, int duration) {
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(augmentedFunctions);
        Preconditions.checkNotNull(swipeElement);
        Object elementPresent = augmentedFunctions.findElementPresent(swipeElement);
        int x = elementPresent.getLocation().getX() + elementPresent.getSize().getWidth() / 2;
        int y = elementPresent.getLocation().getY() + elementPresent.getSize().getHeight() / 2;
        int swipe = MobileUtil.getVerticalOffset(driver, y, offset);
        for (int iteration = 0; iteration < quantity; ++iteration) {
            driver.swipe(x, y, x, swipe, duration);
            if (!augmentedFunctions.isElementVisibleAfter(elementVisible, 3)) continue;
            return augmentedFunctions.findElementVisible(elementVisible);
        }
        throw new AssertionError((Object)String.format("Swiped %s with an offest of %s times but element %s not found", quantity, offset, elementVisible));
    }

    public static void swipeFullRightAfter(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, WebElement element, int waitTimeInSeconds) {
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(augmentedFunctions);
        Preconditions.checkNotNull(element);
        Dimension size = driver.manage().window().getSize();
        int to = size.getWidth() * 85 / 100;
        int from = size.getWidth() * 15 / 100;
        int y = element.getLocation().getY() + element.getSize().getHeight() / 2;
        driver.swipe(from, y, to, y, 1000);
    }

    public static void swipeFullRightAfter(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By by, int waitTimeInSeconds) {
        Preconditions.checkNotNull(by);
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(augmentedFunctions);
        Object element = augmentedFunctions.findElementPresentAfter(by, waitTimeInSeconds);
        MobileUtil.swipeFullRightAfter(driver, augmentedFunctions, element, waitTimeInSeconds);
    }

    public static void swipeFullLeftAfter(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, WebElement element, int waitTimeInSeconds) {
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(augmentedFunctions);
        Preconditions.checkNotNull(element);
        Dimension size = driver.manage().window().getSize();
        int from = size.getWidth() * 85 / 100;
        int to = size.getWidth() * 15 / 100;
        int y = element.getLocation().getY() + element.getSize().getHeight() / 2;
        driver.swipe(from, y, to, y, 1000);
    }

    public static void swipeFullLeftAfter(AppiumDriver driver, AugmentedFunctions<?> augmentedFunctions, By by, int waitTimeInSeconds) {
        Preconditions.checkNotNull(by);
        Preconditions.checkNotNull(driver);
        Preconditions.checkNotNull(augmentedFunctions);
        Object element = augmentedFunctions.findElementPresentAfter(by, waitTimeInSeconds);
        MobileUtil.swipeFullLeftAfter(driver, augmentedFunctions, element, waitTimeInSeconds);
    }

    private static int getVerticalOffset(AppiumDriver driver, int y, int offset) {
        if (y + offset < 10) {
            return 10;
        }
        if (y + offset > driver.manage().window().getSize().getHeight() - 10) {
            return driver.manage().window().getSize().getHeight() - 10;
        }
        return y + offset;
    }
}

