/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.util;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.esotericsoftware.yamlbeans.YamlException;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.salesforceiq.augmenteddriver.util.YamlCapabilitiesConverter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.openqa.selenium.remote.DesiredCapabilities;

public class TestRunnerConfig {
    private static Class<?> hackClass;
    public static TestRunnerConfig ARGUMENTS;
    @Parameter(names={"-clazz"}, description="Class to run", converter=ClassConverter.class)
    private Class<?> clazz;
    @Parameter(names={"-test"}, description="Test to run", converter=MethodConverter.class)
    private Method test;
    @Parameter(names={"-suites"}, description="Comma delimited suites to run")
    private String suites;
    @Parameter(names={"-suitesPackage"}, description="Base package to grab the tests")
    private String suitesPackage;
    @Parameter(names={"-quantity"}, description="How many times the test is going to run")
    private Integer quantity = 1;
    @Parameter(names={"-parallel"}, description="How many tests in parallel are going to run")
    private Integer parallel = 1;
    @Parameter(names={"-timeoutInMinutes"}, description="Timeout for tests to finish")
    private Integer timeoutInMinutes = 20;
    @Parameter(names={"-sauce"}, description="Whether to run tests on SauceLabs or not")
    private boolean sauce = false;
    @Parameter(names={"-quarantine"}, description="Run quarantined tests")
    private boolean quarantine = false;
    @Parameter(names={"-capabilities"}, description="Path to the YAML with the desired capabilities", converter=CapabilitiesConverter.class)
    private DesiredCapabilities capabilities;
    @Parameter(names={"-conf"}, description="Path to the properties file, conf/augmented.properties by default")
    private String conf = "conf/augmented.properties";
    @Parameter(names={"-app"}, description="Path to file to use as app (IOS) or apk (Android)")
    private String app = "";
    @Parameter(names={"-extra"}, description="Extra parameters that are going to be injected (comma delimited)", converter=ExtraArgumentsConverter.class)
    private Map<String, String> extra = Maps.newHashMap();

    public static TestRunnerConfig initialize(String[] commandLineArgs) {
        TestRunnerConfig result = new TestRunnerConfig();
        JCommander jCommander = new JCommander();
        jCommander.setAcceptUnknownOptions(true);
        jCommander.addObject(result);
        jCommander.parse(commandLineArgs);
        ARGUMENTS = result;
        return ARGUMENTS;
    }

    public static TestRunnerConfig initialize(Properties properties) {
        TestRunnerConfig result = new TestRunnerConfig();
        if (properties.get("CAPABILITIES") != null) {
            result.capabilities = new CapabilitiesConverter().convert((String)properties.get("CAPABILITIES"));
        }
        if (properties.get("SAUCE") != null) {
            result.sauce = Boolean.valueOf((String)properties.get("SAUCE"));
        }
        ARGUMENTS = result;
        return ARGUMENTS;
    }

    public Class<?> clazz() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.clazz;
    }

    public Method test() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.test;
    }

    public List<String> suites() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return Arrays.asList(TestRunnerConfig.ARGUMENTS.suites.split(","));
    }

    public String suitesPackage() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.suitesPackage;
    }

    public int quantity() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.quantity;
    }

    public int parallel() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.parallel;
    }

    public int timeoutInMinutes() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.timeoutInMinutes;
    }

    public boolean sauce() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.sauce;
    }

    public boolean quarantine() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.quarantine;
    }

    public DesiredCapabilities capabilities() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.capabilities;
    }

    public String conf() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.conf;
    }

    public String app() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.app;
    }

    public Map<String, String> extra() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#intialize first");
        return TestRunnerConfig.ARGUMENTS.extra;
    }

    public static class ExtraArgumentsConverter
    implements IStringConverter<Map<String, String>> {
        @Override
        public Map<String, String> convert(String extraArguments) {
            HashMap<String, String> result = Maps.newHashMap();
            if (!Strings.isNullOrEmpty(extraArguments)) {
                Iterable<String> arguments = Splitter.on(Pattern.compile(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")).split(extraArguments);
                arguments.forEach(argument -> {
                    String[] splitted = argument.split("=", 2);
                    if (splitted.length != 2) {
                        throw new IllegalArgumentException(String.format("Argument %s is not well formatted", argument));
                    }
                    if (Strings.isNullOrEmpty(splitted[0])) {
                        throw new IllegalArgumentException(String.format("Key of argument %s is empty", argument));
                    }
                    if (Strings.isNullOrEmpty(splitted[1])) {
                        throw new IllegalArgumentException(String.format("Value of argument %s is empty", argument));
                    }
                    String key = splitted[0].replaceAll("^\"|\"$", "");
                    String value = splitted[1].replaceAll("^\"|\"$", "");
                    result.put(key, value);
                });
            }
            return result;
        }
    }

    public static class MethodConverter
    implements IStringConverter<Method> {
        @Override
        public Method convert(String value) {
            try {
                Preconditions.checkArgument(hackClass != null, "Need to declare -clazz argument first");
                return hackClass.getMethod(value, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format("Parameter -test should be a method of %s, got %s", hackClass.getCanonicalName(), value));
            }
        }
    }

    public static class CapabilitiesConverter
    implements IStringConverter<DesiredCapabilities> {
        @Override
        public DesiredCapabilities convert(String path) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(path), "-capabilities should contain an argument");
            Path yamlPath = Paths.get(path, new String[0]);
            if (!Files.exists(yamlPath, new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("File %s does not exist", yamlPath));
            }
            try {
                return YamlCapabilitiesConverter.convert(yamlPath);
            }
            catch (YamlException e) {
                throw new IllegalArgumentException(String.format("File %s cannot be parsed as YAML file", yamlPath), e);
            }
        }
    }

    public static class ClassConverter
    implements IStringConverter<Class<?>> {
        @Override
        public Class<?> convert(String value) {
            try {
                Class<?> theClass = Class.forName(value);
                hackClass = theClass;
                return theClass;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Parameter -clazz should be a class, got : %s", value));
            }
        }
    }
}

