/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.ClassPath;
import com.salesforceiq.augmenteddriver.util.Suites;
import java.io.IOException;
import java.util.List;

public class TestsFinder {
    private static final ClassLoader CLASS_LOADER = TestsFinder.class.getClassLoader();
    private static final Function<ClassPath.ClassInfo, Class> TO_CLASS = classInfo -> {
        try {
            return CLASS_LOADER.loadClass(classInfo.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    };

    public static List<Class> getTestClassesOfPackage(List<String> suites, String suitesPackage) throws IOException {
        Preconditions.checkNotNull(suites);
        Preconditions.checkArgument(!suites.isEmpty());
        Preconditions.checkArgument(!Strings.isNullOrEmpty(suitesPackage));
        ImmutableList upperSuites = ImmutableList.copyOf(Lists.transform(suites, String::toUpperCase));
        return ImmutableList.copyOf(Iterables.filter(TestsFinder.getAllClassesOfPackage(suitesPackage), clazz -> {
            if (clazz.isAnnotationPresent(Suites.class)) {
                Suites suitesAnnotation = clazz.getAnnotation(Suites.class);
                return Lists.transform(Lists.newArrayList(suitesAnnotation.value()), String::toUpperCase).stream().anyMatch(upperSuites::contains);
            }
            return false;
        }));
    }

    private static List<Class> getAllClassesOfPackage(String suitesPackage) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(suitesPackage));
        ClassPath classPath = ClassPath.from(CLASS_LOADER);
        return ImmutableList.copyOf(Iterables.transform(classPath.getTopLevelClassesRecursive(suitesPackage), TO_CLASS));
    }
}

