/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.util.saucelabs;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.PathConverter;
import com.google.common.base.Preconditions;
import java.nio.file.Path;

public class SauceCommandLineArguments {
    public static SauceCommandLineArguments ARGUMENTS;
    @Parameter(names={"-file"}, description="Path to file to upload", converter=PathConverter.class)
    private Path fileToUpload;
    @Parameter(names={"-overwrite"}, description="Whether to overwrite or not the file in case it exists in SauceLabs")
    private boolean overwrite = true;
    @Parameter(names={"-conf"}, description="Path to the properties file, conf/augmented.properties by default")
    private String conf = "conf/augmented.properties";

    public static SauceCommandLineArguments initialize(String[] args) {
        SauceCommandLineArguments result = new SauceCommandLineArguments();
        JCommander jCommander = new JCommander();
        jCommander.setAcceptUnknownOptions(true);
        jCommander.addObject(result);
        jCommander.parse(args);
        ARGUMENTS = result;
        return ARGUMENTS;
    }

    public Path file() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#initialize first");
        return SauceCommandLineArguments.ARGUMENTS.fileToUpload;
    }

    public boolean overwrite() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#initialize first");
        return SauceCommandLineArguments.ARGUMENTS.overwrite;
    }

    public String conf() {
        Preconditions.checkNotNull(ARGUMENTS, "Call TestRunnerConfig#initialize first");
        return SauceCommandLineArguments.ARGUMENTS.conf;
    }
}

