/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.util.saucelabs;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.salesforceiq.augmenteddriver.util.saucelabs.SauceCommandLineArguments;
import com.saucelabs.saucerest.SauceREST;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class SauceLabsModule
extends AbstractModule {
    @Override
    protected void configure() {
        Properties properties = new Properties();
        this.bind(SauceCommandLineArguments.class).toInstance(SauceCommandLineArguments.ARGUMENTS);
        Path propertiesPath = Paths.get(SauceCommandLineArguments.ARGUMENTS.conf(), new String[0]);
        if (Files.exists(propertiesPath, new LinkOption[0])) {
            try {
                properties.load(new FileInputStream(propertiesPath.toFile()));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load properties file " + propertiesPath, e);
            }
        } else {
            throw new IllegalArgumentException("Properties file does not exist " + propertiesPath);
        }
        String sauceKey = properties.getProperty("SAUCE_KEY");
        String sauceUser = properties.getProperty("SAUCE_USER");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(sauceKey), String.format("Set %s in the properties file", "SAUCE_KEY"));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(sauceUser), String.format("Set %s in the properties file", "SAUCE_USER"));
        this.bind(SauceREST.class).toInstance(new SauceREST(properties.getProperty("SAUCE_USER"), properties.getProperty("SAUCE_KEY")));
    }
}

