/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.web;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.salesforceiq.augmenteddriver.util.AugmentedFunctions;
import com.salesforceiq.augmenteddriver.util.WebDriverUtil;
import com.salesforceiq.augmenteddriver.web.AugmentedWebDriver;
import com.salesforceiq.augmenteddriver.web.AugmentedWebDriverProvider;
import com.salesforceiq.augmenteddriver.web.AugmentedWebElement;
import com.salesforceiq.augmenteddriver.web.AugmentedWebElementFactory;
import com.salesforceiq.augmenteddriver.web.AugmentedWebOnlyFunctions;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;

public class AugmentedWebFunctions
implements AugmentedFunctions<AugmentedWebElement>,
AugmentedWebOnlyFunctions {
    private final SearchContext searchContext;
    private final int waitTimeInSeconds;
    private final AugmentedWebElementFactory augmentedWebElementFactory;
    private final AugmentedWebDriverProvider augmentedWebDriverProvider;

    @Inject
    public AugmentedWebFunctions(@Assisted SearchContext searchContext, @Named(value="WAIT_TIME_IN_SECONDS") String waitTimeInSeconds, AugmentedWebDriverProvider augmentedWebDriverProvider, AugmentedWebElementFactory augmentedWebElementFactory) {
        this.searchContext = Preconditions.checkNotNull(searchContext);
        this.waitTimeInSeconds = Integer.valueOf(Preconditions.checkNotNull(waitTimeInSeconds));
        this.augmentedWebElementFactory = Preconditions.checkNotNull(augmentedWebElementFactory);
        this.augmentedWebDriverProvider = Preconditions.checkNotNull(augmentedWebDriverProvider);
    }

    @Override
    public boolean isElementPresent(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementPresentAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public boolean isElementPresentAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        try {
            this.findElementPresentAfter(by, waitSeconds);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public boolean isElementPresentImmediate(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementPresentAfter(by, 0);
    }

    @Override
    public boolean isElementVisible(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementVisibleAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public boolean isElementVisibleAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        try {
            this.findElementVisibleAfter(by, waitSeconds);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public boolean isElementVisibleImmediate(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementVisibleAfter(by, 0);
    }

    @Override
    public boolean isElementClickable(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementClickableAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public boolean isElementClickableAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        try {
            this.findElementClickableAfter(by, waitSeconds);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public boolean isElementClickableImmediate(By by) {
        Preconditions.checkNotNull(by);
        return this.isElementClickableAfter(by, 0);
    }

    @Override
    public AugmentedWebElement findElementPresent(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementPresentAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedWebElement findElementPresentAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        return this.augmentedWebElementFactory.create(WebDriverUtil.findElementPresentAfter(this.searchContext, by, waitSeconds));
    }

    @Override
    public AugmentedWebElement findElementVisible(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementVisibleAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedWebElement findElementVisibleAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        return this.augmentedWebElementFactory.create(WebDriverUtil.findElementVisibleAfter(this.searchContext, by, waitSeconds));
    }

    @Override
    public AugmentedWebElement findElementClickable(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementClickableAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedWebElement findElementClickableAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        return this.augmentedWebElementFactory.create(WebDriverUtil.findElementClickableAfter(this.searchContext, by, waitSeconds));
    }

    @Override
    public AugmentedWebElement findElementNotMoving(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementNotMovingAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedWebElement findElementNotMovingAfter(By by, int waitSeconds) {
        Preconditions.checkNotNull(by);
        return this.augmentedWebElementFactory.create(WebDriverUtil.findElementNotMovingAfter(this.searchContext, by, waitSeconds));
    }

    @Override
    public AugmentedWebElement findElementContain(By by, String text) {
        return this.findElementContainAfter(by, text, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedWebElement findElementContainAfter(By by, String text, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text));
        return this.augmentedWebElementFactory.create(WebDriverUtil.findElementContainAfter(this.searchContext, by, text, waitInSeconds));
    }

    @Override
    public List<AugmentedWebElement> findElementsVisible(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementsVisibleAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public List<AugmentedWebElement> findElementsVisibleAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        return WebDriverUtil.findElementsVisibleAfter(this.searchContext, by, waitInSeconds).stream().map(webElement -> this.augmentedWebElementFactory.create((WebElement)webElement)).collect(Collectors.toList());
    }

    @Override
    public List<AugmentedWebElement> findElementsPresent(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementsPresentAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public List<AugmentedWebElement> findElementsPresentAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        return WebDriverUtil.findElementsPresentAfter(this.searchContext, by, waitInSeconds).stream().map(webElement -> this.augmentedWebElementFactory.create((WebElement)webElement)).collect(Collectors.toList());
    }

    @Override
    public List<AugmentedWebElement> findElementsClickable(By by) {
        Preconditions.checkNotNull(by);
        return this.findElementsClickableAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public List<AugmentedWebElement> findElementsClickableAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        return WebDriverUtil.findElementsClickableAfter(this.searchContext, by, waitInSeconds).stream().map(webElement -> this.augmentedWebElementFactory.create((WebElement)webElement)).collect(Collectors.toList());
    }

    @Override
    public void waitElementToNotBePresent(By by) {
        this.waitElementToNotBePresentAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public void waitElementToNotBePresentAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        WebDriverUtil.waitElementToNotBePresent(this.searchContext, by, waitInSeconds);
    }

    @Override
    public void waitElementToNotBeVisible(By by) {
        this.waitElementToNotBeVisibleAfter(by, this.waitTimeInSeconds);
    }

    @Override
    public void waitElementToNotBeVisibleAfter(By by, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        WebDriverUtil.waitElementToNotBeVisible(this.searchContext, by, waitInSeconds);
    }

    @Override
    public AugmentedWebElement clickAndPresent(By click, By wait) {
        return this.clickAndPresentAfter(click, wait, this.waitTimeInSeconds);
    }

    @Override
    public AugmentedWebElement clickAndPresentAfter(By click, By wait, int waitInSeconds) {
        Preconditions.checkNotNull(click);
        Preconditions.checkNotNull(wait);
        this.findElementClickableAfter(click, waitInSeconds).click();
        return this.findElementPresentAfter(wait, waitInSeconds);
    }

    @Override
    public void moveToAndClick(By moveTo, By click) {
        WebDriverUtil.moveToAndClick(this.augmentedWebDriverProvider.get(), moveTo, click, this.waitTimeInSeconds);
    }

    @Override
    public void moveToAndClickAfter(By moveTo, By click, int waitInSeconds) {
        WebDriverUtil.moveToAndClick(this.augmentedWebDriverProvider.get(), moveTo, click, waitInSeconds);
    }

    @Override
    public AugmentedWebElement moveTo(By moveTo) {
        return this.augmentedWebElementFactory.create(WebDriverUtil.moveTo(this.augmentedWebDriverProvider.get(), moveTo, this.waitTimeInSeconds));
    }

    @Override
    public AugmentedWebElement moveToAfter(By moveTo, int waitInSeconds) {
        return this.augmentedWebElementFactory.create(WebDriverUtil.moveTo(this.augmentedWebDriverProvider.get(), moveTo, waitInSeconds));
    }

    @Override
    public void clearAndSendKeys(By by, String text) {
        this.clearAndSendKeysAfter(by, text, this.waitTimeInSeconds);
    }

    @Override
    public void clearAndSendKeysAfter(By by, String text, int waitInSeconds) {
        Preconditions.checkNotNull(by);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(text));
        AugmentedWebElement element = this.findElementClickableAfter(by, waitInSeconds);
        element.clear();
        element.sendKeys(text);
    }

    @Override
    public void scrollToBottom() {
        AugmentedWebDriver javascriptExecutor = this.augmentedWebDriverProvider.get();
        javascriptExecutor.executeScript("scroll(0, document.body.scrollHeight);", new Object[0]);
    }

    @Override
    public void scrollToElement(By by) {
        AugmentedWebDriver javascriptExecutor = this.augmentedWebDriverProvider.get();
        AugmentedWebElement elementPresent = this.findElementPresent(by);
        javascriptExecutor.executeScript("arguments[0].scrollIntoView(true);", elementPresent.webElement());
    }
}

