/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.web.pageobjects;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.salesforceiq.augmenteddriver.util.PageObject;
import com.salesforceiq.augmenteddriver.util.PageObjectAssertionsInterface;
import com.salesforceiq.augmenteddriver.web.AugmentedWebDriver;
import com.salesforceiq.augmenteddriver.web.AugmentedWebElement;
import com.salesforceiq.augmenteddriver.web.AugmentedWebFunctions;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageObject;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageObjectActions;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageObjectActionsInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebPageContainerObject
implements WebPageObjectActionsInterface,
PageObjectAssertionsInterface,
PageObject {
    private static final Logger LOG = LoggerFactory.getLogger(WebPageObject.class);
    @Inject
    private Provider<AugmentedWebDriver> driverProvider;
    @Inject
    private WebPageObjectActions webPageObjectActions;
    private AugmentedWebElement container;

    @Override
    public <T extends WebPageObject> T get(Class<T> clazz) {
        return this.webPageObjectActions.get(clazz);
    }

    @Override
    public <T extends WebPageContainerObject> T get(Class<T> clazz, AugmentedWebElement container) {
        return this.webPageObjectActions.get(clazz, container);
    }

    @Override
    public void assertPresent() {
        if (this.visibleBy().isPresent()) {
            this.container().augmented().findElementsVisible(this.visibleBy().get());
        }
    }

    @Override
    public AugmentedWebDriver driver() {
        return this.driverProvider.get();
    }

    @Override
    public AugmentedWebFunctions augmented() {
        return this.driverProvider.get().augmented();
    }

    void setContainer(AugmentedWebElement container) {
        this.container = container;
    }

    public AugmentedWebElement container() {
        return this.container;
    }
}

