/*
 * Decompiled with CFR 0.152.
 */
package com.salesforceiq.augmenteddriver.web.pageobjects;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.salesforceiq.augmenteddriver.web.AugmentedWebDriver;
import com.salesforceiq.augmenteddriver.web.AugmentedWebElement;
import com.salesforceiq.augmenteddriver.web.AugmentedWebFunctions;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageContainerObject;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageObject;
import com.salesforceiq.augmenteddriver.web.pageobjects.WebPageObjectActionsInterface;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPageObjectActions
implements WebPageObjectActionsInterface {
    private static final Logger LOG = LoggerFactory.getLogger(WebPageObjectActions.class);
    @Inject
    private Injector injector;
    @Inject
    private Provider<AugmentedWebDriver> driverProvider;

    @Override
    public <T extends WebPageObject> T get(Class<T> clazz) {
        WebPageObject instance = (WebPageObject)this.injector.getInstance(clazz);
        try {
            instance.assertPresent();
        }
        catch (AssertionError | TimeoutException e) {
            LOG.error(String.format("Page Object %s, not found, message: %s", clazz.getCanonicalName(), ((Throwable)e).getMessage()));
            throw e;
        }
        return (T)instance;
    }

    @Override
    public <T extends WebPageContainerObject> T get(Class<T> clazz, AugmentedWebElement container) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(container);
        WebPageContainerObject instance = (WebPageContainerObject)this.injector.getInstance(clazz);
        instance.setContainer(container);
        try {
            instance.assertPresent();
        }
        catch (AssertionError | TimeoutException e) {
            LOG.error(String.format("Page Object Container %s, not found, message: %s", clazz.getCanonicalName(), ((Throwable)e).getMessage()));
            throw e;
        }
        return (T)instance;
    }

    @Override
    public AugmentedWebDriver driver() {
        Preconditions.checkNotNull(this.driverProvider);
        return Preconditions.checkNotNull(this.driverProvider.get());
    }

    @Override
    public AugmentedWebFunctions augmented() {
        Preconditions.checkNotNull(this.driverProvider);
        Preconditions.checkNotNull(this.driverProvider.get());
        return Preconditions.checkNotNull(this.driverProvider.get().augmented());
    }
}

