/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import com.saucelabs.saucerest.SauceException;
import com.saucelabs.saucerest.SauceSSLSocketFactory;
import com.saucelabs.saucerest.SecurityUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.rmi.UnexpectedException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SauceREST {
    private static final Logger logger = Logger.getLogger(SauceREST.class.getName());
    private static final long HTTP_READ_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    private static final long HTTP_CONNECT_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    protected String username;
    protected String accessKey;
    public static final String RESTURL = "https://saucelabs.com/rest/v1/%1$s";
    private static final String USER_RESULT_FORMAT = "https://saucelabs.com/rest/v1/%1$s/%2$s";
    private static final String GET_JOBS_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs";
    private static final String JOB_RESULT_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs/%2$s";
    private static final String STOP_JOB_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs/%2$s/stop";
    private static final String DOWNLOAD_VIDEO_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs/%2$s/assets/video.flv";
    private static final String DOWNLOAD_LOG_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs/%2$s/assets/selenium-server.log";
    private static final String GET_TUNNELS_FORMAT = "https://saucelabs.com/rest/v1/%1$s/tunnels";
    private static final String GET_ACTIVITY_FORMAT = "https://saucelabs.com/rest/v1/%1$s/activity";
    private static final String GET_TUNNEL_FORMAT = "https://saucelabs.com/rest/v1/%1$s/tunnels/%2$s";
    private static final String GET_CONCURRENCY_FORMAT = "https://saucelabs.com/rest/v1/%1$s/%2$s/concurrency";
    private static final String DATE_FORMAT = "yyyyMMdd_HHmmSS";
    private String server;
    private static final String BASE_URL = System.getenv("SAUCE_REST_ENDPOINT") != null ? System.getenv("SAUCE_REST_ENDPOINT") : "https://saucelabs.com/";

    public SauceREST(String username, String accessKey) {
        this.username = username;
        this.accessKey = accessKey;
        this.server = BASE_URL;
    }

    protected URL buildURL(String endpoint) {
        try {
            return new URL(new URL(this.server), "/rest/" + endpoint);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
            return null;
        }
    }

    protected String getUserAgent() {
        return "SauceREST/" + SauceREST.class.getPackage().getImplementationVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doJSONPOST(URL url, JSONObject body) throws SauceException {
        HttpURLConnection postBack = null;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            String inputLine;
            postBack = this.openConnection(url);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            if (postBack instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)postBack).setSSLSocketFactory(factory);
            }
            postBack.setDoOutput(true);
            postBack.setRequestMethod("POST");
            postBack.setRequestProperty("Content-Type", "application/json");
            this.addAuthenticationProperty(postBack);
            String jsonText = JSONValue.toJSONString(body);
            postBack.getOutputStream().write(jsonText.getBytes());
            reader = new BufferedReader(new InputStreamReader(postBack.getInputStream()));
            while ((inputLine = reader.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        catch (IOException e) {
            try {
                if (postBack.getResponseCode() == 401) {
                    throw new SauceException.NotAuthorized();
                }
            }
            catch (IOException e1) {
                logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + " and getting status code: ", e);
            }
            logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ":", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ":", e);
        }
        catch (KeyManagementException e) {
            logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ":", e);
        }
        finally {
            this.closeInputStream(postBack);
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing Sauce input stream", e);
            }
        }
        return builder.toString();
    }

    public void jobPassed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", true);
        this.updateJobInfo(jobId, updates);
    }

    public void jobFailed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", false);
        this.updateJobInfo(jobId, updates);
    }

    public void downloadVideo(String jobId, String location) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(DOWNLOAD_VIDEO_FORMAT, this.username, jobId));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        this.downloadFile(jobId, location, restEndpoint);
    }

    public void downloadLog(String jobId, String location) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(DOWNLOAD_LOG_FORMAT, this.username, jobId));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        this.downloadFile(jobId, location, restEndpoint);
    }

    public String retrieveResults(String path) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(USER_RESULT_FORMAT, this.username, path));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getJobInfo(String jobId) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(JOB_RESULT_FORMAT, this.username, jobId));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String retrieveResults(URL restEndpoint) {
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            String inputLine;
            HttpURLConnection connection = this.openConnection(restEndpoint);
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            if (connection instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
            }
            connection.setRequestProperty("charset", "utf-8");
            connection.setDoOutput(true);
            this.addAuthenticationProperty(connection);
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = reader.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.SEVERE, "Received a SocketTimeoutException when invoking Sauce REST API, check status.saucelabs.com for network outages", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error retrieving Sauce Results", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "Error retrieving Sauce Results", e);
        }
        catch (KeyManagementException e) {
            logger.log(Level.SEVERE, "Error retrieving Sauce Results", e);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing Sauce input stream", e);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String jobId, String location, URL restEndpoint) {
        FilterOutputStream out = null;
        try {
            int i;
            HttpURLConnection connection = this.openConnection(restEndpoint);
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            this.addAuthenticationProperty(connection);
            InputStream stream = connection.getInputStream();
            BufferedInputStream in = new BufferedInputStream(stream);
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            String saveName = jobId + format.format(new Date());
            saveName = restEndpoint.getPath().endsWith(".flv") ? saveName + ".flv" : saveName + ".log";
            FileOutputStream file = new FileOutputStream(new File(location, saveName));
            out = new BufferedOutputStream(file);
            while ((i = in.read()) != -1) {
                ((BufferedOutputStream)out).write(i);
            }
            ((BufferedOutputStream)out).flush();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error downloading Sauce Results");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void addAuthenticationProperty(HttpURLConnection connection) {
        if (this.username != null && this.accessKey != null) {
            String auth = this.encodeAuthentication();
            connection.setRequestProperty("Authorization", auth);
        }
    }

    public void updateJobInfo(String jobId, Map<String, Object> updates) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = new URL(String.format(JOB_RESULT_FORMAT, this.username, jobId));
            postBack = this.openConnection(restEndpoint);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            postBack.setDoOutput(true);
            postBack.setRequestMethod("PUT");
            this.addAuthenticationProperty(postBack);
            String jsonText = JSONValue.toJSONString(updates);
            postBack.getOutputStream().write(jsonText.getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error updating Sauce Results", e);
        }
        this.closeInputStream(postBack);
    }

    public void stopJob(String jobId) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = new URL(String.format(STOP_JOB_FORMAT, this.username, jobId));
            postBack = this.openConnection(restEndpoint);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            postBack.setDoOutput(true);
            postBack.setRequestMethod("PUT");
            this.addAuthenticationProperty(postBack);
            postBack.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(postBack);
    }

    private void closeInputStream(HttpURLConnection connection) {
        try {
            if (connection != null) {
                connection.getInputStream().close();
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.SEVERE, "Received a SocketTimeoutException when invoking Sauce REST API, check status.saucelabs.com for network outages", e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing result stream", e);
        }
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setReadTimeout((int)HTTP_READ_TIMEOUT_SECONDS);
        con.setConnectTimeout((int)HTTP_CONNECT_TIMEOUT_SECONDS);
        return con;
    }

    public String uploadFile(File file) throws IOException {
        return this.uploadFile(file, file.getName());
    }

    public String uploadFile(File file, String fileName) throws IOException {
        return this.uploadFile(file, fileName, true);
    }

    public String uploadFile(File file, String fileName, Boolean overwrite) throws IOException {
        String line;
        CookieSpecProvider customSpecProvider = new CookieSpecProvider(){

            public CookieSpec create(HttpContext context) {
                return new BrowserCompatSpec(new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "\"EEE, dd-MMM-yyyy HH:mm:ss z\""});
            }
        };
        Registry<CookieSpecProvider> r = RegistryBuilder.create().register("best-match", new BestMatchSpecFactory()).register("custom", (BestMatchSpecFactory)customSpecProvider).build();
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("custom").build();
        CloseableHttpClient client = HttpClients.custom().setDefaultCookieSpecRegistry(r).setDefaultRequestConfig(requestConfig).build();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieSpecRegistry(r);
        HttpPost post = new HttpPost(String.format(RESTURL, "storage/") + this.username + "/" + fileName + "?overwrite=" + overwrite.toString());
        FileEntity entity = new FileEntity(file);
        entity.setContentType(new BasicHeader("Content-Type", "application/octet-stream"));
        post.setEntity(entity);
        post.setHeader("Content-Type", "application/octet-stream");
        post.setHeader("Authorization", this.encodeAuthentication());
        CloseableHttpResponse response = client.execute((HttpUriRequest)post, context);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuilder builder = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            builder.append(line);
        }
        try {
            JSONObject sauceUploadResponse = new JSONObject(builder.toString());
            if (sauceUploadResponse.has("error")) {
                throw new UnexpectedException("Failed to upload to sauce-storage: " + sauceUploadResponse.getString("error"));
            }
            return sauceUploadResponse.getString("md5");
        }
        catch (JSONException j) {
            throw new UnexpectedException("Failed to parse json response.", j);
        }
    }

    public String getPublicJobLink(String jobId) {
        try {
            String key = this.username + ":" + this.accessKey;
            String auth_token = SecurityUtils.hmacEncode("HmacMD5", jobId, key);
            return "https://saucelabs.com/jobs/" + jobId + "?auth=" + auth_token;
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "Unable to create an authenticated public link to job:", ex);
            return "";
        }
    }

    protected String encodeAuthentication() {
        String auth = this.username + ":" + this.accessKey;
        auth = "Basic " + DatatypeConverter.printBase64Binary((byte[])auth.getBytes());
        return auth;
    }

    public void deleteTunnel(String tunnelId) {
        HttpURLConnection connection = null;
        try {
            URL restEndpoint = new URL(String.format(GET_TUNNEL_FORMAT, this.username, tunnelId));
            connection = this.openConnection(restEndpoint);
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            connection.setDoOutput(true);
            connection.setRequestMethod("DELETE");
            this.addAuthenticationProperty(connection);
            connection.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(connection);
    }

    public String getTunnels() {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(GET_TUNNELS_FORMAT, this.username));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getTunnelInformation(String tunnelId) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(GET_TUNNEL_FORMAT, this.username, tunnelId));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getConcurrency() {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(GET_CONCURRENCY_FORMAT, "users", this.username));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getActivity() {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(GET_ACTIVITY_FORMAT, this.username));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getJobsList(String[] args) {
        URL restEndpoint = null;
        try {
            StringBuilder url = new StringBuilder(String.format(GET_JOBS_FORMAT, this.username));
            if (args != null && args.length > 0) {
                int len = args.length;
                url.append("?");
                for (int i = 0; i < len; ++i) {
                    url.append(args[i]);
                    if (len <= 1 || i == len - 1) continue;
                    url.append("&");
                }
                restEndpoint = new URL(url.toString());
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getStoredFiles() {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(RESTURL, "storage") + "/" + this.username);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getUser() {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(USER_RESULT_FORMAT, "users", this.username));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getSupportedPlatforms(String automationApi) {
        URL restEndpoint = this.buildURL("v1/info/platforms/" + automationApi);
        return this.retrieveResults(restEndpoint);
    }

    public boolean recordCI(String platform, String platformVersion) {
        URL restEndpoint = this.buildURL("v1/stats/ci");
        JSONObject obj = new JSONObject();
        try {
            obj.put("platform", platform);
            obj.put("platform_version", platformVersion);
        }
        catch (JSONException e) {
            logger.log(Level.SEVERE, "Error attempting to craft json:", e);
            return false;
        }
        try {
            this.doJSONPOST(restEndpoint, obj);
        }
        catch (SauceException e) {
            return false;
        }
        return true;
    }
}

