/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.google.common.io.Resources;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.io.TemporaryFilesystem;

public class AttachFile
extends SeleneseCommand<Void> {
    private static final Logger LOGGER = Logger.getLogger(AttachFile.class.getName());
    private final ElementFinder finder;

    public AttachFile(ElementFinder finder) {
        this.finder = finder;
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String locator, String value) {
        File file = this.downloadFile(value);
        WebElement element = this.finder.findElement(driver, locator);
        element.clear();
        element.sendKeys(file.getAbsolutePath());
        return null;
    }

    private File downloadFile(String name) {
        URL url = this.getUrl(name);
        File dir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("attachFile", "dir");
        File outputTo = new File(dir, new File(url.getFile()).getName());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputTo);
            Resources.copy(url, fos);
        }
        catch (IOException e) {
            throw new SeleniumException("Can't access file to upload: " + url, e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to close stream used for reading file: " + name, e);
            }
        }
        return outputTo;
    }

    private URL getUrl(String name) {
        try {
            return new URL(name);
        }
        catch (MalformedURLException e) {
            throw new SeleniumException("Malformed URL: " + name);
        }
    }
}

