/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.FindsByIosUIAutomation;
import java.io.Serializable;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public abstract class MobileBy
extends By {
    public static By IosUIAutomation(String uiautomationText) {
        if (uiautomationText == null) {
            throw new IllegalArgumentException("Must supply an iOS UIAutomation string");
        }
        return new ByIosUIAutomation(uiautomationText);
    }

    public static By AndroidUIAutomator(String uiautomatorText) {
        if (uiautomatorText == null) {
            throw new IllegalArgumentException("Must supply an Android UIAutomator string");
        }
        return new ByAndroidUIAutomator(uiautomatorText);
    }

    public static By AccessibilityId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Must supply a uiautomationText");
        }
        return new ByAccessibilityId(id);
    }

    public static class ByAccessibilityId
    extends By
    implements Serializable {
        private final String id;

        public ByAccessibilityId(String id) {
            this.id = id;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByAccessibilityId)((Object)context)).findElementsByAccessibilityId(this.id);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByAccessibilityId)((Object)context)).findElementByAccessibilityId(this.id);
        }

        @Override
        public String toString() {
            return "By.AccessibilityId: " + this.id;
        }
    }

    public static class ByAndroidUIAutomator
    extends By
    implements Serializable {
        private final String automatorText;

        public ByAndroidUIAutomator(String uiautomatorText) {
            this.automatorText = uiautomatorText;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByAndroidUIAutomator)((Object)context)).findElementsByAndroidUIAutomator(this.automatorText);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByAndroidUIAutomator)((Object)context)).findElementByAndroidUIAutomator(this.automatorText);
        }

        @Override
        public String toString() {
            return "By.AndroidUIAutomator: " + this.automatorText;
        }
    }

    public static class ByIosUIAutomation
    extends By
    implements Serializable {
        private final String automationText;

        public ByIosUIAutomation(String uiautomationText) {
            this.automationText = uiautomationText;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return ((FindsByIosUIAutomation)((Object)context)).findElementsByIosUIAutomation(this.automationText);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return ((FindsByIosUIAutomation)((Object)context)).findElementByIosUIAutomation(this.automationText);
        }

        @Override
        public String toString() {
            return "By.IosUIAutomation: " + this.automationText;
        }
    }
}

