/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import com.google.common.base.Function;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.pagefactory.AppiumAnnotations;
import io.appium.java_client.pagefactory.TimeOutDuration;
import io.appium.java_client.pagefactory.WebDriverUnpackUtility;
import io.appium.java_client.pagefactory.WithTimeout;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.FluentWait;

class AppiumElementLocator
implements ElementLocator {
    private final SearchContext searchContext;
    private final boolean shouldCache;
    private final By by;
    private WebElement cachedElement;
    private List<WebElement> cachedElementList;
    private final TimeOutDuration timeOutDuration;

    AppiumElementLocator(SearchContext searchContext, Field field, TimeOutDuration timeOutDuration) {
        this.searchContext = searchContext;
        String platform = this.getPlatform();
        String automation = this.getAutomation();
        AppiumAnnotations annotations = new AppiumAnnotations(field, platform, automation);
        if (field.isAnnotationPresent(WithTimeout.class)) {
            WithTimeout withTimeout = field.getAnnotation(WithTimeout.class);
            this.timeOutDuration = new TimeOutDuration(withTimeout.time(), withTimeout.unit());
        } else {
            this.timeOutDuration = timeOutDuration;
        }
        this.shouldCache = annotations.isLookupCached();
        this.by = annotations.buildBy();
    }

    private String getPlatform() {
        WebDriver d = WebDriverUnpackUtility.unpackWebDriverFromSearchContext(this.searchContext);
        if (d == null) {
            return null;
        }
        Class<?> driverClass = d.getClass();
        if (AndroidDriver.class.isAssignableFrom(driverClass)) {
            return "Android";
        }
        if (IOSDriver.class.isAssignableFrom(driverClass)) {
            return "iOS";
        }
        if (HasCapabilities.class.isAssignableFrom(driverClass)) {
            return String.valueOf(((HasCapabilities)((Object)d)).getCapabilities().getCapability("platformName"));
        }
        return null;
    }

    private String getAutomation() {
        WebDriver d = WebDriverUnpackUtility.unpackWebDriverFromSearchContext(this.searchContext);
        if (d == null) {
            return null;
        }
        if (HasCapabilities.class.isAssignableFrom(d.getClass())) {
            return String.valueOf(((HasCapabilities)((Object)d)).getCapabilities().getCapability("automationName"));
        }
        return null;
    }

    private void changeImplicitlyWaitTimeOut(long newTimeOut, TimeUnit newTimeUnit) {
        WebDriverUnpackUtility.unpackWebDriverFromSearchContext(this.searchContext).manage().timeouts().implicitlyWait(newTimeOut, newTimeUnit);
    }

    private List<WebElement> waitFor() {
        try {
            this.changeImplicitlyWaitTimeOut(0L, TimeUnit.SECONDS);
            FluentWait<By> wait = new FluentWait<By>(this.by);
            wait.withTimeout(this.timeOutDuration.getTime(), this.timeOutDuration.getTimeUnit());
            List<WebElement> list = wait.until(new WaitingFunction(this.searchContext));
            return list;
        }
        catch (TimeoutException timeoutException) {
            ArrayList<WebElement> arrayList = new ArrayList<WebElement>();
            return arrayList;
        }
        finally {
            this.changeImplicitlyWaitTimeOut(this.timeOutDuration.getTime(), this.timeOutDuration.getTimeUnit());
        }
    }

    @Override
    public WebElement findElement() {
        if (this.cachedElement != null && this.shouldCache) {
            return this.cachedElement;
        }
        List<WebElement> result = this.waitFor();
        if (result.size() == 0) {
            String message = "Can't locate an element by this strategy: " + this.by.toString();
            throw new NoSuchElementException(message);
        }
        if (this.shouldCache) {
            this.cachedElement = result.get(0);
        }
        return result.get(0);
    }

    @Override
    public List<WebElement> findElements() {
        if (this.cachedElementList != null && this.shouldCache) {
            return this.cachedElementList;
        }
        List<WebElement> result = this.waitFor();
        if (this.shouldCache) {
            this.cachedElementList = result;
        }
        return result;
    }

    private static class WaitingFunction
    implements Function<By, List<WebElement>> {
        private final SearchContext searchContext;
        private static final String INVALID_SELECTOR_PATTERN = "Invalid locator strategy:";

        private WaitingFunction(SearchContext searchContext) {
            this.searchContext = searchContext;
        }

        @Override
        public List<WebElement> apply(By by) {
            ArrayList<WebElement> result;
            block4: {
                result = new ArrayList<WebElement>();
                try {
                    result.addAll(this.searchContext.findElements(by));
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                }
                catch (RuntimeException e) {
                    if (WaitingFunction.isInvalidSelectorRootCause(e)) break block4;
                    throw e;
                }
            }
            if (result.size() > 0) {
                return result;
            }
            return null;
        }

        private static boolean isInvalidSelectorRootCause(Throwable e) {
            if (e == null) {
                return false;
            }
            if (String.valueOf(e.getMessage()).contains(INVALID_SELECTOR_PATTERN)) {
                return true;
            }
            return WaitingFunction.isInvalidSelectorRootCause(e.getCause());
        }
    }
}

