/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumCommandExecutor
extends HttpCommandExecutor {
    private final DriverService service;

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        super(additionalCommands, addressOfRemoteServer);
        this.service = null;
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service) {
        super(additionalCommands, service.getUrl());
        this.service = service;
    }

    @Override
    public Response execute(Command command) throws IOException, WebDriverException {
        if ("newSession".equals(command.getName()) && this.service != null) {
            this.service.start();
        }
        try {
            Response response = super.execute(command);
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause(t);
            if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused") && this.service != null) {
                if (this.service.isRunning()) {
                    throw new WebDriverException("The session is closed!", t);
                }
                if (!this.service.isRunning()) {
                    throw new WebDriverException("The appium server has accidentally died!", t);
                }
            }
            Throwables.propagateIfPossible(t);
            throw new WebDriverException(t);
        }
        finally {
            if ("quit".equals(command.getName()) && this.service != null) {
                this.service.stop();
            }
        }
    }
}

