/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends DriverService {
    public static final String GECKO_DRIVER_EXE_PROPERTY = "webdriver.gecko.driver";

    private GeckoDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)((Builder)new Builder().usingAnyFreePort()).build();
    }

    @Override
    protected void waitUntilAvailable() throws MalformedURLException {
    }

    public static class Builder
    extends DriverService.Builder<GeckoDriverService, Builder> {
        @Override
        protected File findDefaultExecutable() {
            return GeckoDriverService.findExecutable("wires", GeckoDriverService.GECKO_DRIVER_EXE_PROPERTY, "https://github.com/jgraham/wires", "https://github.com/jgraham/wires");
        }

        @Override
        protected ImmutableList<String> createArgs() {
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add(String.format("--webdriver-port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add(String.format("--log-file=\"%s\"", this.getLogFile().getAbsolutePath()));
            }
            argsBuilder.add("-b");
            argsBuilder.add(new Executable(null).getPath());
            return argsBuilder.build();
        }

        @Override
        protected GeckoDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new GeckoDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

