/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import com.saucelabs.saucerest.BuildUtils;
import com.saucelabs.saucerest.SauceException;
import com.saucelabs.saucerest.SauceSSLSocketFactory;
import com.saucelabs.saucerest.SecurityUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.rmi.UnexpectedException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SauceREST
implements Serializable {
    private static final Logger logger = Logger.getLogger(SauceREST.class.getName());
    private static final long HTTP_READ_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    private static final long HTTP_CONNECT_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    protected String username;
    protected String accessKey;
    private static final String DATE_FORMAT = "yyyyMMdd_HHmmSS";
    private static String extraUserAgent = "";
    private String server;
    private static final String BASE_URL = System.getenv("SAUCE_REST_ENDPOINT") != null ? System.getenv("SAUCE_REST_ENDPOINT") : System.getProperty("saucerest-java.base_url", "https://saucelabs.com/");

    public SauceREST(String username, String accessKey) {
        this.username = username;
        this.accessKey = accessKey;
        this.server = BASE_URL;
    }

    public static String getExtraUserAgent() {
        return extraUserAgent;
    }

    public static void setExtraUserAgent(String extraUserAgent) {
        SauceREST.extraUserAgent = extraUserAgent;
    }

    public String getUsername() {
        return this.username;
    }

    protected URL buildURL(String endpoint) {
        try {
            return new URL(new URL(this.server), "/rest/" + endpoint);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
            return null;
        }
    }

    protected String getUserAgent() {
        String userAgent = "SauceREST/" + BuildUtils.getCurrentVersion();
        if (!"".equals(SauceREST.getExtraUserAgent())) {
            userAgent = userAgent + " " + SauceREST.getExtraUserAgent();
        }
        return userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doJSONPOST(URL url, JSONObject body) throws SauceException {
        HttpURLConnection postBack = null;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            String inputLine;
            postBack = this.openConnection(url);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            if (postBack instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)postBack).setSSLSocketFactory(factory);
            }
            postBack.setDoOutput(true);
            postBack.setRequestMethod("POST");
            postBack.setRequestProperty("Content-Type", "application/json");
            this.addAuthenticationProperty(postBack);
            String jsonText = JSONValue.toJSONString((Object)body);
            postBack.getOutputStream().write(jsonText.getBytes());
            reader = new BufferedReader(new InputStreamReader(postBack.getInputStream()));
            while ((inputLine = reader.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        catch (IOException e) {
            try {
                if (postBack.getResponseCode() == 401) {
                    throw new SauceException.NotAuthorized();
                }
            }
            catch (IOException e1) {
                logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + " and getting status code: ", e);
            }
            logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ":", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ":", e);
        }
        catch (KeyManagementException e) {
            logger.log(Level.SEVERE, "Error POSTing to " + url.toString() + ":", e);
        }
        finally {
            this.closeInputStream(postBack);
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error closing Sauce input stream", e);
            }
        }
        return builder.toString();
    }

    public void jobPassed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", true);
        this.updateJobInfo(jobId, updates);
    }

    public void jobFailed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", false);
        this.updateJobInfo(jobId, updates);
    }

    public void downloadVideo(String jobId, String location) {
        URL restEndpoint = this.buildURL("v1/" + this.username + "/jobs/" + jobId + "/assets/video.flv");
        this.downloadFile(jobId, location, restEndpoint);
    }

    public void downloadLog(String jobId, String location) {
        URL restEndpoint = this.buildURL("v1/" + this.username + "/jobs/" + jobId + "/assets/selenium-server.log");
        this.downloadFile(jobId, location, restEndpoint);
    }

    public String retrieveResults(String path) {
        URL restEndpoint = this.buildURL("v1/" + path);
        return this.retrieveResults(restEndpoint);
    }

    public String getJobInfo(String jobId) {
        URL restEndpoint = this.buildURL("v1/" + this.username + "/jobs/" + jobId);
        return this.retrieveResults(restEndpoint);
    }

    public String getFullJobs() {
        return this.getFullJobs(20);
    }

    public String getFullJobs(int limit) {
        URL restEndpoint = this.buildURL("v1/" + this.username + "/jobs?full=true&limit=" + limit);
        return this.retrieveResults(restEndpoint);
    }

    public String retrieveResults(URL restEndpoint) {
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            String inputLine;
            HttpURLConnection connection = this.openConnection(restEndpoint);
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            if (connection instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
            }
            connection.setRequestProperty("charset", "utf-8");
            connection.setDoOutput(true);
            this.addAuthenticationProperty(connection);
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = reader.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.SEVERE, "Received a SocketTimeoutException when invoking Sauce REST API, check status.saucelabs.com for network outages", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error retrieving Sauce Results", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "Error retrieving Sauce Results", e);
        }
        catch (KeyManagementException e) {
            logger.log(Level.SEVERE, "Error retrieving Sauce Results", e);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing Sauce input stream", e);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String jobId, String location, URL restEndpoint) {
        FilterOutputStream out = null;
        try {
            int i;
            HttpURLConnection connection = this.openConnection(restEndpoint);
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            this.addAuthenticationProperty(connection);
            InputStream stream = connection.getInputStream();
            BufferedInputStream in = new BufferedInputStream(stream);
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            String saveName = jobId + format.format(new Date());
            saveName = restEndpoint.getPath().endsWith(".flv") ? saveName + ".flv" : saveName + ".log";
            FileOutputStream file = new FileOutputStream(new File(location, saveName));
            out = new BufferedOutputStream(file);
            while ((i = in.read()) != -1) {
                ((BufferedOutputStream)out).write(i);
            }
            ((BufferedOutputStream)out).flush();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error downloading Sauce Results");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void addAuthenticationProperty(HttpURLConnection connection) {
        if (this.username != null && this.accessKey != null) {
            String auth = this.encodeAuthentication();
            connection.setRequestProperty("Authorization", auth);
        }
    }

    public void updateJobInfo(String jobId, Map<String, Object> updates) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = this.buildURL("v1/" + this.username + "/jobs/" + jobId);
            postBack = this.openConnection(restEndpoint);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            postBack.setDoOutput(true);
            postBack.setRequestMethod("PUT");
            this.addAuthenticationProperty(postBack);
            String jsonText = JSONValue.toJSONString(updates);
            postBack.getOutputStream().write(jsonText.getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error updating Sauce Results", e);
        }
        this.closeInputStream(postBack);
    }

    public void stopJob(String jobId) {
        HttpURLConnection postBack = null;
        try {
            URL restEndpoint = this.buildURL("v1/" + this.username + "/jobs/" + jobId + "/stop");
            postBack = this.openConnection(restEndpoint);
            postBack.setRequestProperty("User-Agent", this.getUserAgent());
            postBack.setDoOutput(true);
            postBack.setRequestMethod("PUT");
            this.addAuthenticationProperty(postBack);
            postBack.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(postBack);
    }

    private void closeInputStream(HttpURLConnection connection) {
        try {
            if (connection != null) {
                connection.getInputStream().close();
            }
        }
        catch (SocketTimeoutException e) {
            logger.log(Level.SEVERE, "Received a SocketTimeoutException when invoking Sauce REST API, check status.saucelabs.com for network outages", e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing result stream", e);
        }
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setReadTimeout((int)HTTP_READ_TIMEOUT_SECONDS);
        con.setConnectTimeout((int)HTTP_CONNECT_TIMEOUT_SECONDS);
        return con;
    }

    public String uploadFile(File file) throws IOException {
        return this.uploadFile(file, file.getName());
    }

    public String uploadFile(File file, String fileName) throws IOException {
        return this.uploadFile(file, fileName, (Boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(File file, String fileName, Boolean overwrite) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = this.uploadFile(is, fileName, (Boolean)true);
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String uploadFile(InputStream is, String fileName, Boolean overwrite) throws IOException {
        try {
            String line;
            URL restEndpoint = this.buildURL("v1/storage/" + this.username + "/" + fileName + "?overwrite=" + overwrite.toString());
            HttpURLConnection connection = this.openConnection(restEndpoint);
            if (connection instanceof HttpsURLConnection) {
                SauceSSLSocketFactory factory = new SauceSSLSocketFactory();
                ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
            }
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            this.addAuthenticationProperty(connection);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            DataOutputStream oos = new DataOutputStream(connection.getOutputStream());
            int c = 0;
            byte[] buf = new byte[8192];
            while ((c = is.read(buf, 0, buf.length)) > 0) {
                oos.write(buf, 0, c);
                oos.flush();
            }
            oos.close();
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                builder.append(line);
            }
            JSONObject sauceUploadResponse = new JSONObject(builder.toString());
            if (sauceUploadResponse.has("error")) {
                throw new UnexpectedException("Failed to upload to sauce-storage: " + sauceUploadResponse.getString("error"));
            }
            return sauceUploadResponse.getString("md5");
        }
        catch (JSONException e) {
            throw new UnexpectedException("Failed to parse json response.", (Exception)((Object)e));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnexpectedException("Failed to get algorithm.", e);
        }
        catch (KeyManagementException e) {
            throw new UnexpectedException("Failed to get key management.", e);
        }
    }

    public String getPublicJobLink(String jobId) {
        try {
            String key = this.username + ":" + this.accessKey;
            String auth_token = SecurityUtils.hmacEncode("HmacMD5", jobId, key);
            return "https://saucelabs.com/jobs/" + jobId + "?auth=" + auth_token;
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.WARNING, "Unable to create an authenticated public link to job:", ex);
            return "";
        }
    }

    protected String encodeAuthentication() {
        String auth = this.username + ":" + this.accessKey;
        auth = "Basic " + DatatypeConverter.printBase64Binary((byte[])auth.getBytes());
        return auth;
    }

    public void deleteTunnel(String tunnelId) {
        HttpURLConnection connection = null;
        try {
            URL restEndpoint = this.buildURL("v1/" + this.username + "/tunnels/" + tunnelId);
            connection = this.openConnection(restEndpoint);
            connection.setRequestProperty("User-Agent", this.getUserAgent());
            connection.setDoOutput(true);
            connection.setRequestMethod("DELETE");
            this.addAuthenticationProperty(connection);
            connection.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        this.closeInputStream(connection);
    }

    public String getTunnels() {
        URL restEndpoint = this.buildURL("v1/" + this.username + "/tunnels");
        return this.retrieveResults(restEndpoint);
    }

    public String getTunnelInformation(String tunnelId) {
        URL restEndpoint = this.buildURL("v1/" + this.username + "/tunnels/" + tunnelId);
        return this.retrieveResults(restEndpoint);
    }

    public String getConcurrency() {
        URL restEndpoint = this.buildURL("v1/users/" + this.username + "/concurrency");
        return this.retrieveResults(restEndpoint);
    }

    public String getActivity() {
        URL restEndpoint = this.buildURL("v1/" + this.username + "/activity");
        return this.retrieveResults(restEndpoint);
    }

    public String getStoredFiles() {
        URL restEndpoint = this.buildURL("v1/storage/" + this.username);
        return this.retrieveResults(restEndpoint);
    }

    public String getUser() {
        URL restEndpoint = this.buildURL("v1/users/" + this.username);
        return this.retrieveResults(restEndpoint);
    }

    public String getSupportedPlatforms(String automationApi) {
        URL restEndpoint = this.buildURL("v1/info/platforms/" + automationApi);
        return this.retrieveResults(restEndpoint);
    }

    public String getBuildFullJobs(String build) {
        URL restEndpoint = this.buildURL("v1/" + this.username + "/build/" + build + "/jobs?full=1");
        return this.retrieveResults(restEndpoint);
    }

    public boolean recordCI(String platform, String platformVersion) {
        URL restEndpoint = this.buildURL("v1/stats/ci");
        JSONObject obj = new JSONObject();
        try {
            obj.put("platform", (Object)platform);
            obj.put("platform_version", (Object)platformVersion);
        }
        catch (JSONException e) {
            logger.log(Level.SEVERE, "Error attempting to craft json:", e);
            return false;
        }
        try {
            this.doJSONPOST(restEndpoint, obj);
        }
        catch (SauceException e) {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof SauceREST)) {
            return super.equals(obj);
        }
        SauceREST sauceobj = (SauceREST)obj;
        if (!Objects.equals(sauceobj.username, this.username)) return false;
        if (!Objects.equals(sauceobj.accessKey, this.accessKey)) return false;
        if (!Objects.equals(sauceobj.server, this.server)) return false;
        if (!Objects.equals(BASE_URL, BASE_URL)) return false;
        return true;
    }
}

