/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal._ResponseCommonKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.cache.CacheInterceptorKt;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/cache/CacheInterceptor;", "Lokhttp3/Interceptor;", "cache", "Lokhttp3/Cache;", "(Lokhttp3/Cache;)V", "getCache$okhttp", "()Lokhttp3/Cache;", "cacheWritingResponse", "Lokhttp3/Response;", "cacheRequest", "Lokhttp3/internal/cache/CacheRequest;", "response", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "okhttp"})
public final class CacheInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Cache cache;

    public CacheInterceptor(@Nullable Cache cache) {
        this.cache = cache;
    }

    @Nullable
    public final Cache getCache$okhttp() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response networkResponse;
        Object listener;
        Response cacheResponse;
        Request networkRequest;
        Call call;
        block15: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            call = chain.call();
            Cache cache = this.cache;
            Response cacheCandidate = cache != null ? cache.get$okhttp(CacheInterceptorKt.access$requestForCache(chain.request())) : null;
            long now = System.currentTimeMillis();
            CacheStrategy strategy = new CacheStrategy.Factory(now, chain.request(), cacheCandidate).compute();
            networkRequest = strategy.getNetworkRequest();
            cacheResponse = strategy.getCacheResponse();
            Cache cache2 = this.cache;
            if (cache2 != null) {
                cache2.trackResponse$okhttp(strategy);
            }
            if ((object = call instanceof RealCall ? (RealCall)call : null) == null || (object = ((RealCall)object).getEventListener$okhttp()) == null) {
                object = listener = EventListener.NONE;
            }
            if (cacheCandidate != null && cacheResponse == null) {
                _UtilCommonKt.closeQuietly(cacheCandidate.body());
            }
            if (networkRequest == null && cacheResponse == null) {
                Response response;
                Response it = response = new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
                boolean bl = false;
                ((EventListener)listener).satisfactionFailure(call, it);
                return response;
            }
            if (networkRequest == null) {
                Response response;
                Response response2 = cacheResponse;
                Intrinsics.checkNotNull((Object)response2);
                Response it = response = response2.newBuilder().cacheResponse(_ResponseCommonKt.stripBody(cacheResponse)).build();
                boolean bl2 = false;
                ((EventListener)listener).cacheHit(call, it);
                return response;
            }
            if (cacheResponse != null) {
                ((EventListener)listener).cacheConditionalHit(call, cacheResponse);
            } else if (this.cache != null) {
                ((EventListener)listener).cacheMiss(call);
            }
            networkResponse = null;
            try {
                networkResponse = chain.proceed(networkRequest);
                if (networkResponse != null || cacheCandidate == null) break block15;
            }
            catch (Throwable it) {
                if (cacheCandidate == null) throw it;
                _UtilCommonKt.closeQuietly(cacheCandidate.body());
                throw it;
            }
            _UtilCommonKt.closeQuietly(cacheCandidate.body());
        }
        if (cacheResponse != null) {
            Response response = networkResponse;
            boolean bl = response != null ? response.code() == 304 : false;
            if (bl) {
                Response bl2;
                Response response3 = cacheResponse.newBuilder().headers(CacheInterceptor.Companion.combine(cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(_ResponseCommonKt.stripBody(cacheResponse)).networkResponse(_ResponseCommonKt.stripBody(networkResponse)).build();
                networkResponse.body().close();
                Cache cache = this.cache;
                Intrinsics.checkNotNull((Object)cache);
                cache.trackConditionalCacheHit$okhttp();
                this.cache.update$okhttp(cacheResponse, response3);
                Response it = bl2 = response3;
                boolean bl3 = false;
                ((EventListener)listener).cacheHit(call, it);
                return bl2;
            }
            _UtilCommonKt.closeQuietly(cacheResponse.body());
        }
        Response response = networkResponse;
        Intrinsics.checkNotNull((Object)response);
        Response response4 = cacheResponse;
        Response response5 = response.newBuilder().cacheResponse(response4 != null ? _ResponseCommonKt.stripBody(response4) : null).networkResponse(_ResponseCommonKt.stripBody(networkResponse)).build();
        if (this.cache == null) return response5;
        Request cacheNetworkRequest = CacheInterceptorKt.access$requestForCache(networkRequest);
        if (HttpHeaders.promisesBody(response5) && CacheStrategy.Companion.isCacheable(response5, cacheNetworkRequest)) {
            Response response6;
            CacheRequest cacheRequest = this.cache.put$okhttp(response5.newBuilder().request(cacheNetworkRequest).build());
            Response it = response6 = this.cacheWritingResponse(cacheRequest, response5);
            boolean bl = false;
            if (cacheResponse == null) return response6;
            ((EventListener)listener).cacheMiss(call);
            return response6;
        }
        if (!HttpMethod.invalidatesCache(networkRequest.method())) return response5;
        try {
            this.cache.remove$okhttp(networkRequest);
            return response5;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response5;
    }

    private final Response cacheWritingResponse(CacheRequest cacheRequest, Response response) throws IOException {
        if (cacheRequest == null) {
            return response;
        }
        Sink cacheBodyUnbuffered = cacheRequest.body();
        BufferedSource source = response.body().source();
        BufferedSink cacheBody = Okio.buffer((Sink)cacheBodyUnbuffered);
        Source cacheWritingSource2 = new Source(source, cacheRequest, cacheBody){
            private boolean cacheRequestClosed;
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ CacheRequest $cacheRequest;
            final /* synthetic */ BufferedSink $cacheBody;
            {
                this.$source = $source;
                this.$cacheRequest = $cacheRequest;
                this.$cacheBody = $cacheBody;
            }

            public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                long bytesRead = 0L;
                try {
                    bytesRead = this.$source.read(sink, byteCount);
                }
                catch (IOException e) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheRequest.abort();
                    }
                    throw e;
                }
                if (bytesRead == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheBody.close();
                    }
                    return -1L;
                }
                sink.copyTo(this.$cacheBody.getBuffer(), sink.size() - bytesRead, bytesRead);
                this.$cacheBody.emitCompleteSegments();
                return bytesRead;
            }

            @NotNull
            public Timeout timeout() {
                return this.$source.timeout();
            }

            public void close() throws IOException {
                if (!this.cacheRequestClosed && !_UtilJvmKt.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.$cacheRequest.abort();
                }
                this.$source.close();
            }
        };
        String contentType = Response.header$default(response, "Content-Type", null, 2, null);
        long contentLength = response.body().contentLength();
        return response.newBuilder().body(new RealResponseBody(contentType, contentLength, Okio.buffer((Source)cacheWritingSource2))).build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lokhttp3/internal/cache/CacheInterceptor$Companion;", "", "()V", "combine", "Lokhttp3/Headers;", "cachedHeaders", "networkHeaders", "isContentSpecificHeader", "", "fieldName", "", "isEndToEnd", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        private final Headers combine(Headers cachedHeaders, Headers networkHeaders) {
            String fieldName;
            int index;
            Headers.Builder result = new Headers.Builder();
            int n = cachedHeaders.size();
            for (index = 0; index < n; ++index) {
                fieldName = cachedHeaders.name(index);
                String value = cachedHeaders.value(index);
                if (StringsKt.equals((String)"Warning", (String)fieldName, (boolean)true) && StringsKt.startsWith$default((String)value, (String)"1", (boolean)false, (int)2, null) || !this.isContentSpecificHeader(fieldName) && this.isEndToEnd(fieldName) && networkHeaders.get(fieldName) != null) continue;
                result.addLenient$okhttp(fieldName, value);
            }
            n = networkHeaders.size();
            for (index = 0; index < n; ++index) {
                fieldName = networkHeaders.name(index);
                if (this.isContentSpecificHeader(fieldName) || !this.isEndToEnd(fieldName)) continue;
                result.addLenient$okhttp(fieldName, networkHeaders.value(index));
            }
            return result.build();
        }

        private final boolean isEndToEnd(String fieldName) {
            return !StringsKt.equals((String)"Connection", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Keep-Alive", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authenticate", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authorization", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"TE", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Trailers", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Transfer-Encoding", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Upgrade", (String)fieldName, (boolean)true);
        }

        private final boolean isContentSpecificHeader(String fieldName) {
            return StringsKt.equals((String)"Content-Length", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Encoding", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Type", (String)fieldName, (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

