/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BankAccount;
import com.stripe.model.Card;
import com.stripe.model.CustomerCardCollection;
import com.stripe.model.CustomerCollection;
import com.stripe.model.CustomerSubscriptionCollection;
import com.stripe.model.DeletedCustomer;
import com.stripe.model.Discount;
import com.stripe.model.ExternalAccountCollection;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.NextRecurringCharge;
import com.stripe.model.ShippingDetails;
import com.stripe.model.Subscription;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.HashMap;
import java.util.Map;

public class Customer
extends APIResource
implements MetadataStore<Customer>,
HasId {
    Long created;
    String id;
    Boolean livemode;
    Boolean deleted;
    String description;
    String defaultCard;
    String defaultSource;
    String email;
    Long trialEnd;
    Discount discount;
    NextRecurringCharge nextRecurringCharge;
    CustomerSubscriptionCollection subscriptions;
    Subscription subscription;
    Boolean delinquent;
    Integer accountBalance;
    String currency;
    CustomerCardCollection cards;
    ExternalAccountCollection sources;
    Map<String, String> metadata;
    ShippingDetails shipping;

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultCard() {
        return this.defaultCard;
    }

    public void setDefaultCard(String defaultCard) {
        this.defaultCard = defaultCard;
    }

    public String getDefaultSource() {
        return this.defaultSource;
    }

    public void setDefaultSource(String defaultSource) {
        this.defaultSource = defaultSource;
    }

    public CustomerCardCollection getCards() {
        return this.cards;
    }

    public ExternalAccountCollection getSources() {
        return this.sources;
    }

    public void setSources(ExternalAccountCollection sources) {
        this.sources = sources;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getTrialEnd() {
        return this.trialEnd;
    }

    public void setTrialEnd(Long trialEnd) {
        this.trialEnd = trialEnd;
    }

    public Discount getDiscount() {
        return this.discount;
    }

    public void setDiscount(Discount discount) {
        this.discount = discount;
    }

    public NextRecurringCharge getNextRecurringCharge() {
        return this.nextRecurringCharge;
    }

    public void setNextRecurringCharge(NextRecurringCharge nextRecurringCharge) {
        this.nextRecurringCharge = nextRecurringCharge;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public CustomerSubscriptionCollection getSubscriptions() {
        return this.subscriptions;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Boolean getDelinquent() {
        return this.delinquent;
    }

    public void setDelinquent(Boolean delinquent) {
        this.delinquent = delinquent;
    }

    public Integer getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(Integer accountBalance) {
        this.accountBalance = accountBalance;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ShippingDetails getShipping() {
        return this.shipping;
    }

    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    public static Customer create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.create(params, (RequestOptions)null);
    }

    public static Customer retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.retrieve(id, (RequestOptions)null);
    }

    public Customer update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public DeletedCustomer delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete((RequestOptions)null);
    }

    public Card createCard(String token) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(token, (RequestOptions)null);
    }

    public Card createCard(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(params, (RequestOptions)null);
    }

    public BankAccount createBankAccount(String token) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccount(token, (RequestOptions)null);
    }

    public BankAccount createBankAccount(String token, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        postParams.put("bank_account", token);
        return this.createBankAccount(postParams, options);
    }

    public BankAccount createBankAccount(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createBankAccount(params, (RequestOptions)null);
    }

    public BankAccount createBankAccount(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/bank_accounts", Customer.instanceURL(Customer.class, this.id)), params, BankAccount.class, options);
    }

    public Subscription createSubscription(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createSubscription(params, (RequestOptions)null);
    }

    public Subscription updateSubscription(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateSubscription(params, (RequestOptions)null);
    }

    public Subscription cancelSubscription() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(null, (RequestOptions)null);
    }

    public Subscription cancelSubscription(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(params, (RequestOptions)null);
    }

    public void deleteDiscount() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount((RequestOptions)null);
    }

    @Deprecated
    public static Customer create(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.create(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Customer create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, Customer.classURL(Customer.class), params, Customer.class, options);
    }

    @Deprecated
    public static Customer retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static Customer retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.GET, Customer.instanceURL(Customer.class, id), null, Customer.class, options);
    }

    public static CustomerCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.list(params, null);
    }

    public static CustomerCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.requestCollection(Customer.classURL(Customer.class), params, CustomerCollection.class, options);
    }

    @Deprecated
    public static CustomerCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.list(params, null);
    }

    @Deprecated
    public static CustomerCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static CustomerCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.list(params, options);
    }

    @Deprecated
    public Customer update(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Customer update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, Customer.instanceURL(Customer.class, this.id), params, Customer.class, options);
    }

    @Deprecated
    public DeletedCustomer delete(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Object result = null;
        return this.delete(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public DeletedCustomer delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.DELETE, Customer.instanceURL(Customer.class, this.id), null, DeletedCustomer.class, options);
    }

    @Deprecated
    public Card createCard(String token, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(token, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Card createCard(String token, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        postParams.put("card", token);
        return this.createCard(postParams, options);
    }

    @Deprecated
    public Card createCard(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createCard(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Card createCard(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/cards", Customer.instanceURL(Customer.class, this.id)), params, Card.class, options);
    }

    @Deprecated
    public Subscription createSubscription(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.createSubscription(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription createSubscription(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/subscriptions", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class, options);
    }

    @Deprecated
    public Subscription updateSubscription(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.updateSubscription(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription updateSubscription(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.POST, String.format("%s/subscription", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class, options);
    }

    @Deprecated
    public Subscription cancelSubscription(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription cancelSubscription(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(null, options);
    }

    @Deprecated
    public Subscription cancelSubscription(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.cancelSubscription(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public Subscription cancelSubscription(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Customer.request(APIResource.RequestMethod.DELETE, String.format("%s/subscription", Customer.instanceURL(Customer.class, this.id)), params, Subscription.class, options);
    }

    @Deprecated
    public void deleteDiscount(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.deleteDiscount(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public void deleteDiscount(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Customer.request(APIResource.RequestMethod.DELETE, String.format("%s/discount", Customer.instanceURL(Customer.class, this.id)), null, Discount.class, options);
    }
}

