/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.model.HasId;
import com.stripe.model.StripeCollectionInterface;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class PagingIterator<T extends HasId>
extends APIResource
implements Iterator<T> {
    private final String url;
    private final Class<? extends StripeCollectionInterface> collectionType;
    private StripeCollectionInterface<T> currentCollection;
    private Iterator<T> currentDataIterator;
    private String lastId;

    PagingIterator(StripeCollectionInterface<T> stripeCollection) {
        this.url = Stripe.getApiBase() + stripeCollection.getURL();
        this.collectionType = stripeCollection.getClass();
        this.currentCollection = stripeCollection;
        this.currentDataIterator = stripeCollection.getData().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.currentDataIterator.hasNext() || this.currentCollection.getHasMore() != false;
    }

    @Override
    public T next() {
        if (!this.currentDataIterator.hasNext() && this.currentCollection.getHasMore().booleanValue()) {
            try {
                HashMap<String, Object> params = new HashMap<String, Object>();
                Map<String, Object> initialParams = this.currentCollection.getRequestParams();
                if (initialParams != null) {
                    params.putAll(initialParams);
                }
                params.put("starting_after", this.lastId);
                this.currentCollection = this.list(params, this.currentCollection.getRequestOptions());
                this.currentDataIterator = this.currentCollection.getData().iterator();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to lazy-load stripe objects", e);
            }
        }
        if (this.currentDataIterator.hasNext()) {
            HasId next = (HasId)this.currentDataIterator.next();
            this.lastId = next.getId();
            return (T)next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private StripeCollectionInterface<T> list(Map<String, Object> params, RequestOptions options) throws Exception {
        return APIResource.requestCollection(this.url, params, this.collectionType, options);
    }
}

