/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stripe.model.EventDataClassLookup;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExpandableFieldSerializer;
import com.stripe.model.StripeActiveObject;
import com.stripe.model.StripeObjectInterface;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.net.ApiResource;
import com.stripe.net.StripeResponse;
import com.stripe.net.StripeResponseGetter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

public abstract class StripeObject
implements StripeObjectInterface {
    public static final Gson PRETTY_PRINT_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(ExpandableField.class, (Object)new ExpandableFieldSerializer()).create();
    private transient StripeResponse lastResponse;
    private transient JsonObject rawJsonObject;

    public String toString() {
        return String.format("<%s@%s id=%s> JSON: %s", this.getClass().getName(), System.identityHashCode(this), this.getIdString(), PRETTY_PRINT_GSON.toJson((Object)this));
    }

    @Override
    public StripeResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public void setLastResponse(StripeResponse response) {
        this.lastResponse = response;
    }

    public JsonObject getRawJsonObject() {
        if (this.rawJsonObject == null && this.getLastResponse() != null) {
            this.rawJsonObject = (JsonObject)ApiResource.INTERNAL_GSON.fromJson((String)this.getLastResponse().body(), JsonObject.class);
        }
        return this.rawJsonObject;
    }

    public String toJson() {
        return PRETTY_PRINT_GSON.toJson((Object)this);
    }

    private Object getIdString() {
        try {
            Field idField = this.getClass().getDeclaredField("id");
            return idField.get(this);
        }
        catch (SecurityException e) {
            return "";
        }
        catch (NoSuchFieldException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
    }

    protected static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    static StripeObject deserializeStripeObject(JsonObject eventDataObjectJson, StripeResponseGetter responseGetter) {
        String type = eventDataObjectJson.getAsJsonObject().get("object").getAsString();
        Class<? extends StripeObject> cl = EventDataClassLookup.classLookup.get(type);
        StripeObject object = ApiResource.deserializeStripeObject(eventDataObjectJson, cl != null ? cl : StripeRawJsonObject.class, responseGetter);
        return object;
    }

    public static StripeObject deserializeStripeObject(JsonObject payload, Type type, StripeResponseGetter responseGetter) {
        StripeObject object = (StripeObject)ApiResource.INTERNAL_GSON.fromJson((JsonElement)payload, type);
        if (object instanceof StripeActiveObject) {
            ((StripeActiveObject)((Object)object)).setResponseGetter(responseGetter);
        }
        return object;
    }

    public static <T> T deserializeStripeObject(String payload, Class<T> type, StripeResponseGetter responseGetter) {
        return (T)StripeObject.deserializeStripeObject(payload, type, responseGetter);
    }

    public static StripeObject deserializeStripeObject(String payload, Type type, StripeResponseGetter responseGetter) {
        StripeObject object = (StripeObject)ApiResource.INTERNAL_GSON.fromJson(payload, type);
        if (object instanceof StripeActiveObject) {
            ((StripeActiveObject)((Object)object)).setResponseGetter(responseGetter);
        }
        return object;
    }
}

