/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.reporting;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.reporting.ReportTypeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.reporting.ReportTypeListParams;
import com.stripe.param.reporting.ReportTypeRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ReportType
extends ApiResource
implements HasId {
    @SerializedName(value="data_available_end")
    Long dataAvailableEnd;
    @SerializedName(value="data_available_start")
    Long dataAvailableStart;
    @SerializedName(value="default_columns")
    List<String> defaultColumns;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="updated")
    Long updated;
    @SerializedName(value="version")
    Long version;

    public static ReportTypeCollection list(Map<String, Object> params) throws StripeException {
        return ReportType.list(params, (RequestOptions)null);
    }

    public static ReportTypeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/reporting/report_types";
        return (ReportTypeCollection)ReportType.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)ReportTypeCollection.class), options, ApiMode.V1);
    }

    public static ReportTypeCollection list(ReportTypeListParams params) throws StripeException {
        return ReportType.list(params, (RequestOptions)null);
    }

    public static ReportTypeCollection list(ReportTypeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/reporting/report_types";
        ApiResource.checkNullTypedParams(path, params);
        return (ReportTypeCollection)ReportType.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ReportTypeCollection.class), options, ApiMode.V1);
    }

    public static ReportType retrieve(String reportType) throws StripeException {
        return ReportType.retrieve(reportType, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static ReportType retrieve(String reportType, RequestOptions options) throws StripeException {
        return ReportType.retrieve(reportType, (Map<String, Object>)null, options);
    }

    public static ReportType retrieve(String reportType, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reporting/report_types/%s", ApiResource.urlEncodeId(reportType));
        return (ReportType)ReportType.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)ReportType.class), options, ApiMode.V1);
    }

    public static ReportType retrieve(String reportType, ReportTypeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reporting/report_types/%s", ApiResource.urlEncodeId(reportType));
        ApiResource.checkNullTypedParams(path, params);
        return (ReportType)ReportType.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ReportType.class), options, ApiMode.V1);
    }

    @Generated
    public Long getDataAvailableEnd() {
        return this.dataAvailableEnd;
    }

    @Generated
    public Long getDataAvailableStart() {
        return this.dataAvailableStart;
    }

    @Generated
    public List<String> getDefaultColumns() {
        return this.defaultColumns;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public void setDataAvailableEnd(Long dataAvailableEnd) {
        this.dataAvailableEnd = dataAvailableEnd;
    }

    @Generated
    public void setDataAvailableStart(Long dataAvailableStart) {
        this.dataAvailableStart = dataAvailableStart;
    }

    @Generated
    public void setDefaultColumns(List<String> defaultColumns) {
        this.defaultColumns = defaultColumns;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public void setVersion(Long version) {
        this.version = version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportType)) {
            return false;
        }
        ReportType other = (ReportType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$dataAvailableEnd = this.getDataAvailableEnd();
        Long other$dataAvailableEnd = other.getDataAvailableEnd();
        if (this$dataAvailableEnd == null ? other$dataAvailableEnd != null : !((Object)this$dataAvailableEnd).equals(other$dataAvailableEnd)) {
            return false;
        }
        Long this$dataAvailableStart = this.getDataAvailableStart();
        Long other$dataAvailableStart = other.getDataAvailableStart();
        if (this$dataAvailableStart == null ? other$dataAvailableStart != null : !((Object)this$dataAvailableStart).equals(other$dataAvailableStart)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        List<String> this$defaultColumns = this.getDefaultColumns();
        List<String> other$defaultColumns = other.getDefaultColumns();
        if (this$defaultColumns == null ? other$defaultColumns != null : !((Object)this$defaultColumns).equals(other$defaultColumns)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReportType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $dataAvailableEnd = this.getDataAvailableEnd();
        result = result * 59 + ($dataAvailableEnd == null ? 43 : ((Object)$dataAvailableEnd).hashCode());
        Long $dataAvailableStart = this.getDataAvailableStart();
        result = result * 59 + ($dataAvailableStart == null ? 43 : ((Object)$dataAvailableStart).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        List<String> $defaultColumns = this.getDefaultColumns();
        result = result * 59 + ($defaultColumns == null ? 43 : ((Object)$defaultColumns).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

