/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntent;
import com.stripe.model.RefundCollection;
import com.stripe.model.StripeObject;
import com.stripe.model.TransferReversal;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.RefundCancelParams;
import com.stripe.param.RefundCreateParams;
import com.stripe.param.RefundExpireParams;
import com.stripe.param.RefundListParams;
import com.stripe.param.RefundRetrieveParams;
import com.stripe.param.RefundUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class Refund
extends ApiResource
implements MetadataStore<Refund>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="charge")
    ExpandableField<Charge> charge;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="failure_balance_transaction")
    ExpandableField<BalanceTransaction> failureBalanceTransaction;
    @SerializedName(value="failure_reason")
    String failureReason;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="instructions_email")
    String instructionsEmail;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="next_action")
    NextAction nextAction;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="reason")
    String reason;
    @SerializedName(value="receipt_number")
    String receiptNumber;
    @SerializedName(value="source_transfer_reversal")
    ExpandableField<TransferReversal> sourceTransferReversal;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="transfer_reversal")
    ExpandableField<TransferReversal> transferReversal;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String id) {
        this.charge = ApiResource.setExpandableFieldId(id, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge expandableObject) {
        this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getFailureBalanceTransaction() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getId() : null;
    }

    public void setFailureBalanceTransaction(String id) {
        this.failureBalanceTransaction = ApiResource.setExpandableFieldId(id, this.failureBalanceTransaction);
    }

    public BalanceTransaction getFailureBalanceTransactionObject() {
        return this.failureBalanceTransaction != null ? this.failureBalanceTransaction.getExpanded() : null;
    }

    public void setFailureBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.failureBalanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public String getSourceTransferReversal() {
        return this.sourceTransferReversal != null ? this.sourceTransferReversal.getId() : null;
    }

    public void setSourceTransferReversal(String id) {
        this.sourceTransferReversal = ApiResource.setExpandableFieldId(id, this.sourceTransferReversal);
    }

    public TransferReversal getSourceTransferReversalObject() {
        return this.sourceTransferReversal != null ? this.sourceTransferReversal.getExpanded() : null;
    }

    public void setSourceTransferReversalObject(TransferReversal expandableObject) {
        this.sourceTransferReversal = new ExpandableField<TransferReversal>(expandableObject.getId(), expandableObject);
    }

    public String getTransferReversal() {
        return this.transferReversal != null ? this.transferReversal.getId() : null;
    }

    public void setTransferReversal(String id) {
        this.transferReversal = ApiResource.setExpandableFieldId(id, this.transferReversal);
    }

    public TransferReversal getTransferReversalObject() {
        return this.transferReversal != null ? this.transferReversal.getExpanded() : null;
    }

    public void setTransferReversalObject(TransferReversal expandableObject) {
        this.transferReversal = new ExpandableField<TransferReversal>(expandableObject.getId(), expandableObject);
    }

    public Refund cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Refund cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Refund cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Refund cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        return (Refund)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Refund.class), options, ApiMode.V1);
    }

    public Refund cancel(RefundCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Refund cancel(RefundCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Refund)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Refund.class), options, ApiMode.V1);
    }

    public static Refund create(Map<String, Object> params) throws StripeException {
        return Refund.create(params, (RequestOptions)null);
    }

    public static Refund create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        return (Refund)Refund.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Refund.class), options, ApiMode.V1);
    }

    public static Refund create(RefundCreateParams params) throws StripeException {
        return Refund.create(params, (RequestOptions)null);
    }

    public static Refund create(RefundCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        ApiResource.checkNullTypedParams(path, params);
        return (Refund)Refund.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Refund.class), options, ApiMode.V1);
    }

    public static RefundCollection list(Map<String, Object> params) throws StripeException {
        return Refund.list(params, (RequestOptions)null);
    }

    public static RefundCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        return (RefundCollection)Refund.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)RefundCollection.class), options, ApiMode.V1);
    }

    public static RefundCollection list(RefundListParams params) throws StripeException {
        return Refund.list(params, (RequestOptions)null);
    }

    public static RefundCollection list(RefundListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/refunds";
        ApiResource.checkNullTypedParams(path, params);
        return (RefundCollection)Refund.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)RefundCollection.class), options, ApiMode.V1);
    }

    public static Refund retrieve(String refund) throws StripeException {
        return Refund.retrieve(refund, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Refund retrieve(String refund, RequestOptions options) throws StripeException {
        return Refund.retrieve(refund, (Map<String, Object>)null, options);
    }

    public static Refund retrieve(String refund, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(refund));
        return (Refund)Refund.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Refund.class), options, ApiMode.V1);
    }

    public static Refund retrieve(String refund, RefundRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(refund));
        ApiResource.checkNullTypedParams(path, params);
        return (Refund)Refund.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Refund.class), options, ApiMode.V1);
    }

    public Refund update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Refund update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(this.getId()));
        return (Refund)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Refund.class), options, ApiMode.V1);
    }

    public Refund update(RefundUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Refund update(RefundUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/refunds/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Refund)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Refund.class), options, ApiMode.V1);
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.balanceTransaction, responseGetter);
        this.trySetResponseGetter(this.charge, responseGetter);
        this.trySetResponseGetter(this.failureBalanceTransaction, responseGetter);
        this.trySetResponseGetter(this.nextAction, responseGetter);
        this.trySetResponseGetter(this.paymentIntent, responseGetter);
        this.trySetResponseGetter(this.sourceTransferReversal, responseGetter);
        this.trySetResponseGetter(this.transferReversal, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureReason() {
        return this.failureReason;
    }

    @Generated
    public String getInstructionsEmail() {
        return this.instructionsEmail;
    }

    @Generated
    public NextAction getNextAction() {
        return this.nextAction;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInstructionsEmail(String instructionsEmail) {
        this.instructionsEmail = instructionsEmail;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNextAction(NextAction nextAction) {
        this.nextAction = nextAction;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Refund)) {
            return false;
        }
        Refund other = (Refund)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$failureBalanceTransaction = this.getFailureBalanceTransaction();
        String other$failureBalanceTransaction = other.getFailureBalanceTransaction();
        if (this$failureBalanceTransaction == null ? other$failureBalanceTransaction != null : !this$failureBalanceTransaction.equals(other$failureBalanceTransaction)) {
            return false;
        }
        String this$failureReason = this.getFailureReason();
        String other$failureReason = other.getFailureReason();
        if (this$failureReason == null ? other$failureReason != null : !this$failureReason.equals(other$failureReason)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$instructionsEmail = this.getInstructionsEmail();
        String other$instructionsEmail = other.getInstructionsEmail();
        if (this$instructionsEmail == null ? other$instructionsEmail != null : !this$instructionsEmail.equals(other$instructionsEmail)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        NextAction this$nextAction = this.getNextAction();
        NextAction other$nextAction = other.getNextAction();
        if (this$nextAction == null ? other$nextAction != null : !((Object)this$nextAction).equals(other$nextAction)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        String this$sourceTransferReversal = this.getSourceTransferReversal();
        String other$sourceTransferReversal = other.getSourceTransferReversal();
        if (this$sourceTransferReversal == null ? other$sourceTransferReversal != null : !this$sourceTransferReversal.equals(other$sourceTransferReversal)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transferReversal = this.getTransferReversal();
        String other$transferReversal = other.getTransferReversal();
        return !(this$transferReversal == null ? other$transferReversal != null : !this$transferReversal.equals(other$transferReversal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Refund;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $failureBalanceTransaction = this.getFailureBalanceTransaction();
        result = result * 59 + ($failureBalanceTransaction == null ? 43 : $failureBalanceTransaction.hashCode());
        String $failureReason = this.getFailureReason();
        result = result * 59 + ($failureReason == null ? 43 : $failureReason.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $instructionsEmail = this.getInstructionsEmail();
        result = result * 59 + ($instructionsEmail == null ? 43 : $instructionsEmail.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        NextAction $nextAction = this.getNextAction();
        result = result * 59 + ($nextAction == null ? 43 : ((Object)$nextAction).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        String $sourceTransferReversal = this.getSourceTransferReversal();
        result = result * 59 + ($sourceTransferReversal == null ? 43 : $sourceTransferReversal.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transferReversal = this.getTransferReversal();
        result = result * 59 + ($transferReversal == null ? 43 : $transferReversal.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class TestHelpers {
        private final Refund resource;

        private TestHelpers(Refund resource) {
            this.resource = resource;
        }

        public Refund expire() throws StripeException {
            return this.expire((Map<String, Object>)null, (RequestOptions)null);
        }

        public Refund expire(RequestOptions options) throws StripeException {
            return this.expire((Map<String, Object>)null, options);
        }

        public Refund expire(Map<String, Object> params) throws StripeException {
            return this.expire(params, (RequestOptions)null);
        }

        public Refund expire(Map<String, Object> params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/refunds/%s/expire", ApiResource.urlEncodeId(this.resource.getId()));
            return (Refund)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Refund.class), options, ApiMode.V1);
        }

        public Refund expire(RefundExpireParams params) throws StripeException {
            return this.expire(params, (RequestOptions)null);
        }

        public Refund expire(RefundExpireParams params, RequestOptions options) throws StripeException {
            String path = String.format("/v1/test_helpers/refunds/%s/expire", ApiResource.urlEncodeId(this.resource.getId()));
            ApiResource.checkNullTypedParams(path, params);
            return (Refund)this.resource.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Refund.class), options, ApiMode.V1);
        }
    }

    public static class NextAction
    extends StripeObject {
        @SerializedName(value="display_details")
        DisplayDetails displayDetails;
        @SerializedName(value="type")
        String type;

        @Generated
        public DisplayDetails getDisplayDetails() {
            return this.displayDetails;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setDisplayDetails(DisplayDetails displayDetails) {
            this.displayDetails = displayDetails;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NextAction)) {
                return false;
            }
            NextAction other = (NextAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DisplayDetails this$displayDetails = this.getDisplayDetails();
            DisplayDetails other$displayDetails = other.getDisplayDetails();
            if (this$displayDetails == null ? other$displayDetails != null : !((Object)this$displayDetails).equals(other$displayDetails)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NextAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DisplayDetails $displayDetails = this.getDisplayDetails();
            result = result * 59 + ($displayDetails == null ? 43 : ((Object)$displayDetails).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class DisplayDetails
        extends StripeObject {
            @SerializedName(value="email_sent")
            EmailSent emailSent;
            @SerializedName(value="expires_at")
            Long expiresAt;

            @Generated
            public EmailSent getEmailSent() {
                return this.emailSent;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public void setEmailSent(EmailSent emailSent) {
                this.emailSent = emailSent;
            }

            @Generated
            public void setExpiresAt(Long expiresAt) {
                this.expiresAt = expiresAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayDetails)) {
                    return false;
                }
                DisplayDetails other = (DisplayDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                EmailSent this$emailSent = this.getEmailSent();
                EmailSent other$emailSent = other.getEmailSent();
                return !(this$emailSent == null ? other$emailSent != null : !((Object)this$emailSent).equals(other$emailSent));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                EmailSent $emailSent = this.getEmailSent();
                result = result * 59 + ($emailSent == null ? 43 : ((Object)$emailSent).hashCode());
                return result;
            }

            public static class EmailSent
            extends StripeObject {
                @SerializedName(value="email_sent_at")
                Long emailSentAt;
                @SerializedName(value="email_sent_to")
                String emailSentTo;

                @Generated
                public Long getEmailSentAt() {
                    return this.emailSentAt;
                }

                @Generated
                public String getEmailSentTo() {
                    return this.emailSentTo;
                }

                @Generated
                public void setEmailSentAt(Long emailSentAt) {
                    this.emailSentAt = emailSentAt;
                }

                @Generated
                public void setEmailSentTo(String emailSentTo) {
                    this.emailSentTo = emailSentTo;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof EmailSent)) {
                        return false;
                    }
                    EmailSent other = (EmailSent)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$emailSentAt = this.getEmailSentAt();
                    Long other$emailSentAt = other.getEmailSentAt();
                    if (this$emailSentAt == null ? other$emailSentAt != null : !((Object)this$emailSentAt).equals(other$emailSentAt)) {
                        return false;
                    }
                    String this$emailSentTo = this.getEmailSentTo();
                    String other$emailSentTo = other.getEmailSentTo();
                    return !(this$emailSentTo == null ? other$emailSentTo != null : !this$emailSentTo.equals(other$emailSentTo));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof EmailSent;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $emailSentAt = this.getEmailSentAt();
                    result = result * 59 + ($emailSentAt == null ? 43 : ((Object)$emailSentAt).hashCode());
                    String $emailSentTo = this.getEmailSentTo();
                    result = result * 59 + ($emailSentTo == null ? 43 : $emailSentTo.hashCode());
                    return result;
                }
            }
        }
    }
}

