/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.PaymentIntent;
import com.stripe.model.ReviewCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ReviewApproveParams;
import com.stripe.param.ReviewListParams;
import com.stripe.param.ReviewRetrieveParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class Review
extends ApiResource
implements HasId {
    @SerializedName(value="billing_zip")
    String billingZip;
    @SerializedName(value="charge")
    ExpandableField<Charge> charge;
    @SerializedName(value="closed_reason")
    String closedReason;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="ip_address")
    String ipAddress;
    @SerializedName(value="ip_address_location")
    IpAddressLocation ipAddressLocation;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="open")
    Boolean open;
    @SerializedName(value="opened_reason")
    String openedReason;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="reason")
    String reason;
    @SerializedName(value="session")
    Session session;

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String id) {
        this.charge = ApiResource.setExpandableFieldId(id, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge expandableObject) {
        this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public Review approve() throws StripeException {
        return this.approve((Map<String, Object>)null, (RequestOptions)null);
    }

    public Review approve(RequestOptions options) throws StripeException {
        return this.approve((Map<String, Object>)null, options);
    }

    public Review approve(Map<String, Object> params) throws StripeException {
        return this.approve(params, (RequestOptions)null);
    }

    public Review approve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reviews/%s/approve", ApiResource.urlEncodeId(this.getId()));
        return (Review)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Review.class), options, ApiMode.V1);
    }

    public Review approve(ReviewApproveParams params) throws StripeException {
        return this.approve(params, (RequestOptions)null);
    }

    public Review approve(ReviewApproveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reviews/%s/approve", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Review)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Review.class), options, ApiMode.V1);
    }

    public static ReviewCollection list(Map<String, Object> params) throws StripeException {
        return Review.list(params, (RequestOptions)null);
    }

    public static ReviewCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/reviews";
        return (ReviewCollection)Review.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)ReviewCollection.class), options, ApiMode.V1);
    }

    public static ReviewCollection list(ReviewListParams params) throws StripeException {
        return Review.list(params, (RequestOptions)null);
    }

    public static ReviewCollection list(ReviewListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/reviews";
        ApiResource.checkNullTypedParams(path, params);
        return (ReviewCollection)Review.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ReviewCollection.class), options, ApiMode.V1);
    }

    public static Review retrieve(String review) throws StripeException {
        return Review.retrieve(review, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Review retrieve(String review, RequestOptions options) throws StripeException {
        return Review.retrieve(review, (Map<String, Object>)null, options);
    }

    public static Review retrieve(String review, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reviews/%s", ApiResource.urlEncodeId(review));
        return (Review)Review.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Review.class), options, ApiMode.V1);
    }

    public static Review retrieve(String review, ReviewRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/reviews/%s", ApiResource.urlEncodeId(review));
        ApiResource.checkNullTypedParams(path, params);
        return (Review)Review.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Review.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.charge, responseGetter);
        this.trySetResponseGetter(this.ipAddressLocation, responseGetter);
        this.trySetResponseGetter(this.paymentIntent, responseGetter);
        this.trySetResponseGetter(this.session, responseGetter);
    }

    @Generated
    public String getBillingZip() {
        return this.billingZip;
    }

    @Generated
    public String getClosedReason() {
        return this.closedReason;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public IpAddressLocation getIpAddressLocation() {
        return this.ipAddressLocation;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Boolean getOpen() {
        return this.open;
    }

    @Generated
    public String getOpenedReason() {
        return this.openedReason;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public Session getSession() {
        return this.session;
    }

    @Generated
    public void setBillingZip(String billingZip) {
        this.billingZip = billingZip;
    }

    @Generated
    public void setClosedReason(String closedReason) {
        this.closedReason = closedReason;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setIpAddressLocation(IpAddressLocation ipAddressLocation) {
        this.ipAddressLocation = ipAddressLocation;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOpen(Boolean open) {
        this.open = open;
    }

    @Generated
    public void setOpenedReason(String openedReason) {
        this.openedReason = openedReason;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setSession(Session session) {
        this.session = session;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Review)) {
            return false;
        }
        Review other = (Review)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Boolean this$open = this.getOpen();
        Boolean other$open = other.getOpen();
        if (this$open == null ? other$open != null : !((Object)this$open).equals(other$open)) {
            return false;
        }
        String this$billingZip = this.getBillingZip();
        String other$billingZip = other.getBillingZip();
        if (this$billingZip == null ? other$billingZip != null : !this$billingZip.equals(other$billingZip)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        String this$closedReason = this.getClosedReason();
        String other$closedReason = other.getClosedReason();
        if (this$closedReason == null ? other$closedReason != null : !this$closedReason.equals(other$closedReason)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        IpAddressLocation this$ipAddressLocation = this.getIpAddressLocation();
        IpAddressLocation other$ipAddressLocation = other.getIpAddressLocation();
        if (this$ipAddressLocation == null ? other$ipAddressLocation != null : !((Object)this$ipAddressLocation).equals(other$ipAddressLocation)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$openedReason = this.getOpenedReason();
        String other$openedReason = other.getOpenedReason();
        if (this$openedReason == null ? other$openedReason != null : !this$openedReason.equals(other$openedReason)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        Session this$session = this.getSession();
        Session other$session = other.getSession();
        return !(this$session == null ? other$session != null : !((Object)this$session).equals(other$session));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Review;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Boolean $open = this.getOpen();
        result = result * 59 + ($open == null ? 43 : ((Object)$open).hashCode());
        String $billingZip = this.getBillingZip();
        result = result * 59 + ($billingZip == null ? 43 : $billingZip.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        String $closedReason = this.getClosedReason();
        result = result * 59 + ($closedReason == null ? 43 : $closedReason.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        IpAddressLocation $ipAddressLocation = this.getIpAddressLocation();
        result = result * 59 + ($ipAddressLocation == null ? 43 : ((Object)$ipAddressLocation).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $openedReason = this.getOpenedReason();
        result = result * 59 + ($openedReason == null ? 43 : $openedReason.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        Session $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : ((Object)$session).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class IpAddressLocation
    extends StripeObject {
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="latitude")
        BigDecimal latitude;
        @SerializedName(value="longitude")
        BigDecimal longitude;
        @SerializedName(value="region")
        String region;

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public BigDecimal getLatitude() {
            return this.latitude;
        }

        @Generated
        public BigDecimal getLongitude() {
            return this.longitude;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setLatitude(BigDecimal latitude) {
            this.latitude = latitude;
        }

        @Generated
        public void setLongitude(BigDecimal longitude) {
            this.longitude = longitude;
        }

        @Generated
        public void setRegion(String region) {
            this.region = region;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IpAddressLocation)) {
                return false;
            }
            IpAddressLocation other = (IpAddressLocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            BigDecimal this$latitude = this.getLatitude();
            BigDecimal other$latitude = other.getLatitude();
            if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
                return false;
            }
            BigDecimal this$longitude = this.getLongitude();
            BigDecimal other$longitude = other.getLongitude();
            if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            return !(this$region == null ? other$region != null : !this$region.equals(other$region));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof IpAddressLocation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            BigDecimal $latitude = this.getLatitude();
            result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
            BigDecimal $longitude = this.getLongitude();
            result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            return result;
        }
    }

    public static class Session
    extends StripeObject {
        @SerializedName(value="browser")
        String browser;
        @SerializedName(value="device")
        String device;
        @SerializedName(value="platform")
        String platform;
        @SerializedName(value="version")
        String version;

        @Generated
        public String getBrowser() {
            return this.browser;
        }

        @Generated
        public String getDevice() {
            return this.device;
        }

        @Generated
        public String getPlatform() {
            return this.platform;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public void setBrowser(String browser) {
            this.browser = browser;
        }

        @Generated
        public void setDevice(String device) {
            this.device = device;
        }

        @Generated
        public void setPlatform(String platform) {
            this.platform = platform;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Session)) {
                return false;
            }
            Session other = (Session)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$browser = this.getBrowser();
            String other$browser = other.getBrowser();
            if (this$browser == null ? other$browser != null : !this$browser.equals(other$browser)) {
                return false;
            }
            String this$device = this.getDevice();
            String other$device = other.getDevice();
            if (this$device == null ? other$device != null : !this$device.equals(other$device)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Session;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $browser = this.getBrowser();
            result = result * 59 + ($browser == null ? 43 : $browser.hashCode());
            String $device = this.getDevice();
            result = result * 59 + ($device == null ? 43 : $device.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }
    }
}

