/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.climate;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.climate.OrderCollection;
import com.stripe.model.climate.Product;
import com.stripe.model.climate.Supplier;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.climate.OrderCancelParams;
import com.stripe.param.climate.OrderCreateParams;
import com.stripe.param.climate.OrderListParams;
import com.stripe.param.climate.OrderRetrieveParams;
import com.stripe.param.climate.OrderUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Order
extends ApiResource
implements HasId,
MetadataStore<Order> {
    @SerializedName(value="amount_fees")
    Long amountFees;
    @SerializedName(value="amount_subtotal")
    Long amountSubtotal;
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="beneficiary")
    Beneficiary beneficiary;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="cancellation_reason")
    String cancellationReason;
    @SerializedName(value="certificate")
    String certificate;
    @SerializedName(value="confirmed_at")
    Long confirmedAt;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="delayed_at")
    Long delayedAt;
    @SerializedName(value="delivered_at")
    Long deliveredAt;
    @SerializedName(value="delivery_details")
    List<DeliveryDetail> deliveryDetails;
    @SerializedName(value="expected_delivery_year")
    Long expectedDeliveryYear;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="metric_tons")
    BigDecimal metricTons;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="product")
    ExpandableField<Product> product;
    @SerializedName(value="product_substituted_at")
    Long productSubstitutedAt;
    @SerializedName(value="status")
    String status;

    public String getProduct() {
        return this.product != null ? this.product.getId() : null;
    }

    public void setProduct(String id) {
        this.product = ApiResource.setExpandableFieldId(id, this.product);
    }

    public Product getProductObject() {
        return this.product != null ? this.product.getExpanded() : null;
    }

    public void setProductObject(Product expandableObject) {
        this.product = new ExpandableField<Product>(expandableObject.getId(), expandableObject);
    }

    public Order cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public Order cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public Order cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Order cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        return (Order)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Order.class), options, ApiMode.V1);
    }

    public Order cancel(OrderCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public Order cancel(OrderCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Order)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Order.class), options, ApiMode.V1);
    }

    public static Order create(Map<String, Object> params) throws StripeException {
        return Order.create(params, (RequestOptions)null);
    }

    public static Order create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/orders";
        return (Order)Order.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Order.class), options, ApiMode.V1);
    }

    public static Order create(OrderCreateParams params) throws StripeException {
        return Order.create(params, (RequestOptions)null);
    }

    public static Order create(OrderCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/orders";
        ApiResource.checkNullTypedParams(path, params);
        return (Order)Order.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Order.class), options, ApiMode.V1);
    }

    public static OrderCollection list(Map<String, Object> params) throws StripeException {
        return Order.list(params, (RequestOptions)null);
    }

    public static OrderCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/orders";
        return (OrderCollection)Order.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)OrderCollection.class), options, ApiMode.V1);
    }

    public static OrderCollection list(OrderListParams params) throws StripeException {
        return Order.list(params, (RequestOptions)null);
    }

    public static OrderCollection list(OrderListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/climate/orders";
        ApiResource.checkNullTypedParams(path, params);
        return (OrderCollection)Order.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)OrderCollection.class), options, ApiMode.V1);
    }

    public static Order retrieve(String order) throws StripeException {
        return Order.retrieve(order, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Order retrieve(String order, RequestOptions options) throws StripeException {
        return Order.retrieve(order, (Map<String, Object>)null, options);
    }

    public static Order retrieve(String order, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s", ApiResource.urlEncodeId(order));
        return (Order)Order.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Order.class), options, ApiMode.V1);
    }

    public static Order retrieve(String order, OrderRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s", ApiResource.urlEncodeId(order));
        ApiResource.checkNullTypedParams(path, params);
        return (Order)Order.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Order.class), options, ApiMode.V1);
    }

    public Order update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Order update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s", ApiResource.urlEncodeId(this.getId()));
        return (Order)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Order.class), options, ApiMode.V1);
    }

    public Order update(OrderUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Order update(OrderUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/climate/orders/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Order)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Order.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.beneficiary, responseGetter);
        this.trySetResponseGetter(this.product, responseGetter);
    }

    @Generated
    public Long getAmountFees() {
        return this.amountFees;
    }

    @Generated
    public Long getAmountSubtotal() {
        return this.amountSubtotal;
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public Beneficiary getBeneficiary() {
        return this.beneficiary;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Generated
    public String getCertificate() {
        return this.certificate;
    }

    @Generated
    public Long getConfirmedAt() {
        return this.confirmedAt;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Long getDelayedAt() {
        return this.delayedAt;
    }

    @Generated
    public Long getDeliveredAt() {
        return this.deliveredAt;
    }

    @Generated
    public List<DeliveryDetail> getDeliveryDetails() {
        return this.deliveryDetails;
    }

    @Generated
    public Long getExpectedDeliveryYear() {
        return this.expectedDeliveryYear;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public BigDecimal getMetricTons() {
        return this.metricTons;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getProductSubstitutedAt() {
        return this.productSubstitutedAt;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAmountFees(Long amountFees) {
        this.amountFees = amountFees;
    }

    @Generated
    public void setAmountSubtotal(Long amountSubtotal) {
        this.amountSubtotal = amountSubtotal;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setBeneficiary(Beneficiary beneficiary) {
        this.beneficiary = beneficiary;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    @Generated
    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    @Generated
    public void setConfirmedAt(Long confirmedAt) {
        this.confirmedAt = confirmedAt;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDelayedAt(Long delayedAt) {
        this.delayedAt = delayedAt;
    }

    @Generated
    public void setDeliveredAt(Long deliveredAt) {
        this.deliveredAt = deliveredAt;
    }

    @Generated
    public void setDeliveryDetails(List<DeliveryDetail> deliveryDetails) {
        this.deliveryDetails = deliveryDetails;
    }

    @Generated
    public void setExpectedDeliveryYear(Long expectedDeliveryYear) {
        this.expectedDeliveryYear = expectedDeliveryYear;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setMetricTons(BigDecimal metricTons) {
        this.metricTons = metricTons;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setProductSubstitutedAt(Long productSubstitutedAt) {
        this.productSubstitutedAt = productSubstitutedAt;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountFees = this.getAmountFees();
        Long other$amountFees = other.getAmountFees();
        if (this$amountFees == null ? other$amountFees != null : !((Object)this$amountFees).equals(other$amountFees)) {
            return false;
        }
        Long this$amountSubtotal = this.getAmountSubtotal();
        Long other$amountSubtotal = other.getAmountSubtotal();
        if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        Long this$confirmedAt = this.getConfirmedAt();
        Long other$confirmedAt = other.getConfirmedAt();
        if (this$confirmedAt == null ? other$confirmedAt != null : !((Object)this$confirmedAt).equals(other$confirmedAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$delayedAt = this.getDelayedAt();
        Long other$delayedAt = other.getDelayedAt();
        if (this$delayedAt == null ? other$delayedAt != null : !((Object)this$delayedAt).equals(other$delayedAt)) {
            return false;
        }
        Long this$deliveredAt = this.getDeliveredAt();
        Long other$deliveredAt = other.getDeliveredAt();
        if (this$deliveredAt == null ? other$deliveredAt != null : !((Object)this$deliveredAt).equals(other$deliveredAt)) {
            return false;
        }
        Long this$expectedDeliveryYear = this.getExpectedDeliveryYear();
        Long other$expectedDeliveryYear = other.getExpectedDeliveryYear();
        if (this$expectedDeliveryYear == null ? other$expectedDeliveryYear != null : !((Object)this$expectedDeliveryYear).equals(other$expectedDeliveryYear)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$productSubstitutedAt = this.getProductSubstitutedAt();
        Long other$productSubstitutedAt = other.getProductSubstitutedAt();
        if (this$productSubstitutedAt == null ? other$productSubstitutedAt != null : !((Object)this$productSubstitutedAt).equals(other$productSubstitutedAt)) {
            return false;
        }
        Beneficiary this$beneficiary = this.getBeneficiary();
        Beneficiary other$beneficiary = other.getBeneficiary();
        if (this$beneficiary == null ? other$beneficiary != null : !((Object)this$beneficiary).equals(other$beneficiary)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        if (this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason)) {
            return false;
        }
        String this$certificate = this.getCertificate();
        String other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !this$certificate.equals(other$certificate)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        List<DeliveryDetail> this$deliveryDetails = this.getDeliveryDetails();
        List<DeliveryDetail> other$deliveryDetails = other.getDeliveryDetails();
        if (this$deliveryDetails == null ? other$deliveryDetails != null : !((Object)this$deliveryDetails).equals(other$deliveryDetails)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        BigDecimal this$metricTons = this.getMetricTons();
        BigDecimal other$metricTons = other.getMetricTons();
        if (this$metricTons == null ? other$metricTons != null : !((Object)this$metricTons).equals(other$metricTons)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$product = this.getProduct();
        String other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountFees = this.getAmountFees();
        result = result * 59 + ($amountFees == null ? 43 : ((Object)$amountFees).hashCode());
        Long $amountSubtotal = this.getAmountSubtotal();
        result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        Long $confirmedAt = this.getConfirmedAt();
        result = result * 59 + ($confirmedAt == null ? 43 : ((Object)$confirmedAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $delayedAt = this.getDelayedAt();
        result = result * 59 + ($delayedAt == null ? 43 : ((Object)$delayedAt).hashCode());
        Long $deliveredAt = this.getDeliveredAt();
        result = result * 59 + ($deliveredAt == null ? 43 : ((Object)$deliveredAt).hashCode());
        Long $expectedDeliveryYear = this.getExpectedDeliveryYear();
        result = result * 59 + ($expectedDeliveryYear == null ? 43 : ((Object)$expectedDeliveryYear).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $productSubstitutedAt = this.getProductSubstitutedAt();
        result = result * 59 + ($productSubstitutedAt == null ? 43 : ((Object)$productSubstitutedAt).hashCode());
        Beneficiary $beneficiary = this.getBeneficiary();
        result = result * 59 + ($beneficiary == null ? 43 : ((Object)$beneficiary).hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        String $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : $certificate.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        List<DeliveryDetail> $deliveryDetails = this.getDeliveryDetails();
        result = result * 59 + ($deliveryDetails == null ? 43 : ((Object)$deliveryDetails).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        BigDecimal $metricTons = this.getMetricTons();
        result = result * 59 + ($metricTons == null ? 43 : ((Object)$metricTons).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Beneficiary
    extends StripeObject {
        @SerializedName(value="public_name")
        String publicName;

        @Generated
        public String getPublicName() {
            return this.publicName;
        }

        @Generated
        public void setPublicName(String publicName) {
            this.publicName = publicName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Beneficiary)) {
                return false;
            }
            Beneficiary other = (Beneficiary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$publicName = this.getPublicName();
            String other$publicName = other.getPublicName();
            return !(this$publicName == null ? other$publicName != null : !this$publicName.equals(other$publicName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Beneficiary;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $publicName = this.getPublicName();
            result = result * 59 + ($publicName == null ? 43 : $publicName.hashCode());
            return result;
        }
    }

    public static class DeliveryDetail
    extends StripeObject {
        @SerializedName(value="delivered_at")
        Long deliveredAt;
        @SerializedName(value="location")
        Location location;
        @SerializedName(value="metric_tons")
        String metricTons;
        @SerializedName(value="registry_url")
        String registryUrl;
        @SerializedName(value="supplier")
        Supplier supplier;

        @Generated
        public Long getDeliveredAt() {
            return this.deliveredAt;
        }

        @Generated
        public Location getLocation() {
            return this.location;
        }

        @Generated
        public String getMetricTons() {
            return this.metricTons;
        }

        @Generated
        public String getRegistryUrl() {
            return this.registryUrl;
        }

        @Generated
        public Supplier getSupplier() {
            return this.supplier;
        }

        @Generated
        public void setDeliveredAt(Long deliveredAt) {
            this.deliveredAt = deliveredAt;
        }

        @Generated
        public void setLocation(Location location) {
            this.location = location;
        }

        @Generated
        public void setMetricTons(String metricTons) {
            this.metricTons = metricTons;
        }

        @Generated
        public void setRegistryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
        }

        @Generated
        public void setSupplier(Supplier supplier) {
            this.supplier = supplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeliveryDetail)) {
                return false;
            }
            DeliveryDetail other = (DeliveryDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$deliveredAt = this.getDeliveredAt();
            Long other$deliveredAt = other.getDeliveredAt();
            if (this$deliveredAt == null ? other$deliveredAt != null : !((Object)this$deliveredAt).equals(other$deliveredAt)) {
                return false;
            }
            Location this$location = this.getLocation();
            Location other$location = other.getLocation();
            if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
                return false;
            }
            String this$metricTons = this.getMetricTons();
            String other$metricTons = other.getMetricTons();
            if (this$metricTons == null ? other$metricTons != null : !this$metricTons.equals(other$metricTons)) {
                return false;
            }
            String this$registryUrl = this.getRegistryUrl();
            String other$registryUrl = other.getRegistryUrl();
            if (this$registryUrl == null ? other$registryUrl != null : !this$registryUrl.equals(other$registryUrl)) {
                return false;
            }
            Supplier this$supplier = this.getSupplier();
            Supplier other$supplier = other.getSupplier();
            return !(this$supplier == null ? other$supplier != null : !((Object)this$supplier).equals(other$supplier));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DeliveryDetail;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $deliveredAt = this.getDeliveredAt();
            result = result * 59 + ($deliveredAt == null ? 43 : ((Object)$deliveredAt).hashCode());
            Location $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
            String $metricTons = this.getMetricTons();
            result = result * 59 + ($metricTons == null ? 43 : $metricTons.hashCode());
            String $registryUrl = this.getRegistryUrl();
            result = result * 59 + ($registryUrl == null ? 43 : $registryUrl.hashCode());
            Supplier $supplier = this.getSupplier();
            result = result * 59 + ($supplier == null ? 43 : ((Object)$supplier).hashCode());
            return result;
        }

        public static class Location
        extends StripeObject {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="latitude")
            BigDecimal latitude;
            @SerializedName(value="longitude")
            BigDecimal longitude;
            @SerializedName(value="region")
            String region;

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public BigDecimal getLatitude() {
                return this.latitude;
            }

            @Generated
            public BigDecimal getLongitude() {
                return this.longitude;
            }

            @Generated
            public String getRegion() {
                return this.region;
            }

            @Generated
            public void setCity(String city) {
                this.city = city;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLatitude(BigDecimal latitude) {
                this.latitude = latitude;
            }

            @Generated
            public void setLongitude(BigDecimal longitude) {
                this.longitude = longitude;
            }

            @Generated
            public void setRegion(String region) {
                this.region = region;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Location)) {
                    return false;
                }
                Location other = (Location)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                BigDecimal this$latitude = this.getLatitude();
                BigDecimal other$latitude = other.getLatitude();
                if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
                    return false;
                }
                BigDecimal this$longitude = this.getLongitude();
                BigDecimal other$longitude = other.getLongitude();
                if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
                    return false;
                }
                String this$region = this.getRegion();
                String other$region = other.getRegion();
                return !(this$region == null ? other$region != null : !this$region.equals(other$region));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Location;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                BigDecimal $latitude = this.getLatitude();
                result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
                BigDecimal $longitude = this.getLongitude();
                result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
                String $region = this.getRegion();
                result = result * 59 + ($region == null ? 43 : $region.hashCode());
                return result;
            }
        }
    }
}

