/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.net.HttpHeaders;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

abstract class AbstractStripeResponse<T> {
    int code;
    HttpHeaders headers;
    T body;
    int numRetries;

    public final int code() {
        return this.code;
    }

    public final HttpHeaders headers() {
        return this.headers;
    }

    public final T body() {
        return this.body;
    }

    public Instant date() {
        Optional<String> dateStr = this.headers.firstValue("Date");
        if (!dateStr.isPresent()) {
            return null;
        }
        return ZonedDateTime.parse(dateStr.get(), DateTimeFormatter.RFC_1123_DATE_TIME).toInstant();
    }

    public String idempotencyKey() {
        return this.headers.firstValue("Idempotency-Key").orElse(null);
    }

    public String requestId() {
        return this.headers.firstValue("Request-Id").orElse(null);
    }

    protected AbstractStripeResponse(int code, HttpHeaders headers, T body) {
        Objects.requireNonNull(headers);
        Objects.requireNonNull(body);
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    @Generated
    int numRetries() {
        return this.numRetries;
    }

    @Generated
    AbstractStripeResponse<T> numRetries(int numRetries) {
        this.numRetries = numRetries;
        return this;
    }
}

