/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.StripeCollection;
import com.stripe.model.StripeSearchResult;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CustomerCreateParams;
import com.stripe.param.CustomerListParams;
import com.stripe.param.CustomerRetrieveParams;
import com.stripe.param.CustomerSearchParams;
import com.stripe.param.CustomerUpdateParams;
import com.stripe.service.CashBalanceService;
import com.stripe.service.CustomerBalanceTransactionService;
import com.stripe.service.CustomerCashBalanceTransactionService;
import com.stripe.service.CustomerFundingInstructionsService;
import com.stripe.service.CustomerPaymentMethodService;
import com.stripe.service.PaymentSourceService;
import com.stripe.service.TaxIdService;
import java.lang.reflect.Type;

public final class CustomerService
extends ApiService {
    public CustomerService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeSearchResult<Customer> search(CustomerSearchParams params) throws StripeException {
        return this.search(params, null);
    }

    public StripeSearchResult<Customer> search(CustomerSearchParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customers/search";
        return (StripeSearchResult)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeSearchResult<Customer>>(){}.getType(), options, ApiMode.V1);
    }

    public StripeCollection<Customer> list(CustomerListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Customer> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Customer> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Customer> list(CustomerListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customers";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Customer>>(){}.getType(), options, ApiMode.V1);
    }

    public Customer create(CustomerCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Customer create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public Customer create() throws StripeException {
        return this.create(null, null);
    }

    public Customer create(CustomerCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/customers";
        return (Customer)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Customer.class), options, ApiMode.V1);
    }

    public Customer retrieve(String customer, CustomerRetrieveParams params) throws StripeException {
        return this.retrieve(customer, params, null);
    }

    public Customer retrieve(String customer, RequestOptions options) throws StripeException {
        return this.retrieve(customer, null, options);
    }

    public Customer retrieve(String customer) throws StripeException {
        return this.retrieve(customer, null, null);
    }

    public Customer retrieve(String customer, CustomerRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer));
        return (Customer)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Customer.class), options, ApiMode.V1);
    }

    public Customer update(String customer, CustomerUpdateParams params) throws StripeException {
        return this.update(customer, params, null);
    }

    public Customer update(String customer, RequestOptions options) throws StripeException {
        return this.update(customer, null, options);
    }

    public Customer update(String customer) throws StripeException {
        return this.update(customer, null, null);
    }

    public Customer update(String customer, CustomerUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer));
        return (Customer)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Customer.class), options, ApiMode.V1);
    }

    public Customer delete(String customer) throws StripeException {
        return this.delete(customer, null);
    }

    public Customer delete(String customer, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s", ApiResource.urlEncodeId(customer));
        return (Customer)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, (Type)((Object)Customer.class), options, ApiMode.V1);
    }

    public Discount deleteDiscount(String customer) throws StripeException {
        return this.deleteDiscount(customer, null);
    }

    public Discount deleteDiscount(String customer, RequestOptions options) throws StripeException {
        String path = String.format("/v1/customers/%s/discount", ApiResource.urlEncodeId(customer));
        return (Discount)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, (Type)((Object)Discount.class), options, ApiMode.V1);
    }

    public CustomerBalanceTransactionService balanceTransactions() {
        return new CustomerBalanceTransactionService(this.getResponseGetter());
    }

    public CashBalanceService cashBalance() {
        return new CashBalanceService(this.getResponseGetter());
    }

    public CustomerCashBalanceTransactionService cashBalanceTransactions() {
        return new CustomerCashBalanceTransactionService(this.getResponseGetter());
    }

    public CustomerFundingInstructionsService fundingInstructions() {
        return new CustomerFundingInstructionsService(this.getResponseGetter());
    }

    public CustomerPaymentMethodService paymentMethods() {
        return new CustomerPaymentMethodService(this.getResponseGetter());
    }

    public PaymentSourceService paymentSources() {
        return new PaymentSourceService(this.getResponseGetter());
    }

    public TaxIdService taxIds() {
        return new TaxIdService(this.getResponseGetter());
    }
}

