/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.TaxCode;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.TaxCodeListParams;
import com.stripe.param.TaxCodeRetrieveParams;
import java.lang.reflect.Type;

public final class TaxCodeService
extends ApiService {
    public TaxCodeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<TaxCode> list(TaxCodeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<TaxCode> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<TaxCode> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<TaxCode> list(TaxCodeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax_codes";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<TaxCode>>(){}.getType(), options, ApiMode.V1);
    }

    public TaxCode retrieve(String id, TaxCodeRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public TaxCode retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public TaxCode retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public TaxCode retrieve(String id, TaxCodeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax_codes/%s", ApiResource.urlEncodeId(id));
        return (TaxCode)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TaxCode.class), options, ApiMode.V1);
    }
}

